/*
 * Decompiled with CFR 0.152.
 */
package com.witchica.compactstorage.common.block;

import com.witchica.compactstorage.CompactStoragePlatform;
import com.witchica.compactstorage.common.block.entity.CompactChestBlockEntity;
import com.witchica.compactstorage.common.util.CompactStorageUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class CompactChestBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = DirectionProperty.m_61549_((String)"facing", (Direction[])new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST});
    public static final VoxelShape CHEST_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);

    public CompactChestBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        BlockEntity blockEntity;
        CompoundTag nbt;
        BlockEntity blockEntity2;
        super.m_6402_(world, pos, state, placer, itemStack);
        if (itemStack.m_41788_() && (blockEntity2 = world.m_7702_(pos)) instanceof CompactChestBlockEntity) {
            ((CompactChestBlockEntity)blockEntity2).m_58638_(itemStack.m_41786_());
        }
        if (!world.f_46443_ && itemStack.m_41782_() && (nbt = itemStack.m_41783_()).m_128441_("inventory_width") && nbt.m_128441_("inventory_height") && (blockEntity = world.m_7702_(pos)) instanceof CompactChestBlockEntity) {
            CompactChestBlockEntity compactChestBlockEntity = (CompactChestBlockEntity)blockEntity;
            compactChestBlockEntity.inventoryWidth = nbt.m_128451_("inventory_width");
            compactChestBlockEntity.inventoryHeight = nbt.m_128451_("inventory_height");
            compactChestBlockEntity.resizeInventory(false);
            compactChestBlockEntity.m_6596_();
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.f_46443_) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof CompactChestBlockEntity) {
                CompactChestBlockEntity compactChestBlockEntity = (CompactChestBlockEntity)blockEntity;
                Item heldItem = player.m_21120_(hand).m_41720_();
                if (heldItem == CompactStoragePlatform.getStorageRowUpgradeItem()) {
                    if (compactChestBlockEntity.increaseSize(1, 0)) {
                        player.m_21120_(hand).m_41774_(1);
                        player.m_5661_((Component)Component.m_237115_((String)"text.compact_storage.upgrade_success").m_130940_(ChatFormatting.GREEN), true);
                        player.m_6330_(SoundEvents.f_12275_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        return InteractionResult.CONSUME_PARTIAL;
                    }
                    player.m_6330_(SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    player.m_5661_((Component)Component.m_237115_((String)"text.compact_storage.upgrade_fail_maxsize").m_130940_(ChatFormatting.RED), true);
                    return InteractionResult.FAIL;
                }
                if (heldItem == CompactStoragePlatform.getStorageColumnUpgradeItem()) {
                    if (compactChestBlockEntity.increaseSize(0, 1)) {
                        player.m_21120_(hand).m_41774_(1);
                        player.m_5661_((Component)Component.m_237115_((String)"text.compact_storage.upgrade_success").m_130940_(ChatFormatting.GREEN), true);
                        player.m_6330_(SoundEvents.f_12275_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        return InteractionResult.CONSUME_PARTIAL;
                    }
                    player.m_6330_(SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    player.m_5661_((Component)Component.m_237115_((String)"text.compact_storage.upgrade_fail_maxsize").m_130940_(ChatFormatting.RED), true);
                    return InteractionResult.FAIL;
                }
                if (heldItem instanceof DyeItem) {
                    DyeItem dyeItem = (DyeItem)heldItem;
                    Block newBlock = CompactStoragePlatform.getCompactChestFromDyeColor(dyeItem.m_41089_());
                    world.m_46597_(pos, (BlockState)newBlock.m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING))));
                    player.m_6330_(SoundEvents.f_12392_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    player.m_21120_(hand).m_41774_(1);
                    return InteractionResult.CONSUME_PARTIAL;
                }
            }
            this.openMenu(world, player, pos, state, hand);
        }
        return InteractionResult.SUCCESS;
    }

    public abstract void openMenu(Level var1, Player var2, BlockPos var3, BlockState var4, InteractionHand var5);

    @Nullable
    public MenuProvider m_7246_(BlockState state, Level level, BlockPos pos) {
        return super.m_7246_(state, level, pos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return CHEST_SHAPE;
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        CompactStorageUtil.dropContents(world, pos, state.m_60734_(), player);
        super.m_5707_(world, pos, state, player);
    }

    public void m_7592_(Level level, BlockPos pos, Explosion explosion) {
        super.m_7592_(level, pos, explosion);
        CompactStorageUtil.dropContents(level, pos, (Block)this, null);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag options) {
        super.m_5871_(stack, world, tooltip, options);
        CompactStorageUtil.appendTooltip(stack, world, tooltip, options, false);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)world.m_7702_(pos));
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        if (type == CompactStoragePlatform.getCompactChestBlockEntityType()) {
            return (world1, pos, state1, be) -> CompactChestBlockEntity.tick(world1, pos, state1, (CompactChestBlockEntity)be);
        }
        return null;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (state.m_155947_() && !(newState.m_60734_() instanceof CompactChestBlock)) {
            level.m_46747_(pos);
        }
    }
}

