/*
 * Decompiled with CFR 0.152.
 */
package com.witchica.compactstorage.common.block;

import com.witchica.compactstorage.common.block.entity.DrumBlockEntity;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class DrumBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = DirectionProperty.m_156003_((String)"facing");

    public DrumBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)super.m_5573_(ctx).m_61124_((Property)FACING, (Comparable)ctx.m_7820_().m_122424_());
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)super.m_6943_(state, mirror).m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)).m_122424_());
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)super.m_6843_(state, rotation).m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)).m_122427_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag options) {
        super.m_5871_(stack, world, tooltip, options);
        tooltip.add((Component)Component.m_237115_((String)"text.compact_storage.drum.tooltip_1").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        tooltip.add((Component)Component.m_237115_((String)"text.compact_storage.drum.tooltip_2").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new DrumBlockEntity(pos, state);
    }

    public void extractItem(Level world, BlockPos pos, Player player) {
        DrumBlockEntity drumBlockEntity = (DrumBlockEntity)world.m_7702_(pos);
        SimpleContainer inventory = drumBlockEntity.inventory;
        ItemStack extracted = inventory.m_8016_(0);
        if (!extracted.m_41619_()) {
            world.m_7967_((Entity)new ItemEntity(world, (double)player.m_146903_(), (double)player.m_146904_(), (double)player.m_146907_(), extracted));
            world.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void insertItem(Level world, BlockPos pos, Player player, InteractionHand hand) {
        ItemStack itemInHand = player.m_21120_(hand);
        DrumBlockEntity drum = (DrumBlockEntity)world.m_7702_(pos);
        SimpleContainer itemHandler = drum.inventory;
        boolean completed = false;
        if (itemInHand.m_41619_() && drum.hasAnyItems()) {
            Inventory playerInventory = player.m_150109_();
            for (int i = 0; i < playerInventory.m_6643_(); ++i) {
                ItemStack itemStack = playerInventory.m_8020_(i);
                if (!itemHandler.m_7013_(0, itemStack)) continue;
                ItemStack returned = itemHandler.m_19173_(itemStack);
                if (itemStack.m_41613_() == returned.m_41613_()) continue;
                playerInventory.m_6836_(i, returned);
                completed = true;
                break;
            }
        } else {
            ItemStack itemStack = player.m_21120_(hand);
            if (itemHandler.m_7013_(0, itemStack)) {
                ItemStack returned = itemHandler.m_19173_(itemStack);
                if (itemStack.m_41613_() != returned.m_41613_()) {
                    player.m_21008_(hand, returned);
                    completed = true;
                }
            }
        }
        if (completed) {
            world.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.f_46443_) {
            if (player.m_6144_()) {
                this.extractItem(world, pos, player);
            } else {
                this.insertItem(world, pos, player, hand);
            }
        }
        return InteractionResult.CONSUME;
    }

    public void m_6256_(BlockState state, Level world, BlockPos pos, Player player) {
        if (!world.f_46443_) {
            this.extractItem(world, pos, player);
        }
        super.m_6256_(state, world, pos, player);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof DrumBlockEntity) {
            DrumBlockEntity drumBlock = (DrumBlockEntity)blockEntity;
            int totalItemCount = drumBlock.getTotalItemCount();
            int stackSize = drumBlock.getStoredType().m_41459_();
            int output = Mth.m_14143_((float)((float)totalItemCount / (float)stackSize / 64.0f * 15.0f));
            return output;
        }
        return 0;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && (blockEntity = world.m_7702_(pos)) instanceof DrumBlockEntity) {
            DrumBlockEntity drumBlock = (DrumBlockEntity)blockEntity;
            Containers.m_19002_((Level)world, (BlockPos)pos, (Container)drumBlock.inventory);
            world.m_46717_(pos, state.m_60734_());
        }
        super.m_6810_(state, world, pos, newState, moved);
    }
}

