/*
 * Decompiled with CFR 0.152.
 */
package com.witchica.compactstorage.common.client.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.witchica.compactstorage.common.block.DrumBlock;
import com.witchica.compactstorage.common.block.entity.DrumBlockEntity;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.properties.Property;

public class DrumBlockEntityRenderer
implements BlockEntityRenderer<DrumBlockEntity> {
    private final BlockEntityRendererProvider.Context context;

    public DrumBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.context = ctx;
    }

    public void render(DrumBlockEntity drumBlock, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        if (drumBlock == null) {
            return;
        }
        ItemStack stack = drumBlock.clientItem;
        String text = drumBlock.getTextToDisplay();
        Direction direction = (Direction)drumBlock.m_58900_().m_61143_((Property)DrumBlock.FACING);
        if (!stack.m_41619_()) {
            matrices.m_85836_();
            matrices.m_252880_(0.5f, 0.5f, 0.5f);
            matrices.m_252880_((float)direction.m_122429_() * 0.5f, (float)direction.m_122430_() * 0.5f, (float)direction.m_122431_() * 0.5f);
            matrices.m_85841_(0.35f, 0.35f, 0.35f);
            matrices.m_252781_(Axis.f_252436_.m_252977_(direction.m_122435_()));
            if (direction == Direction.UP || direction == Direction.DOWN) {
                matrices.m_252781_(Axis.f_252436_.m_252977_(direction == Direction.UP ? -90.0f : 90.0f));
                matrices.m_252781_(Axis.f_252529_.m_252977_(direction == Direction.UP ? 90.0f : 270.0f));
            }
            matrices.m_252781_(Axis.f_252436_.m_252977_(-direction.m_122435_() * 2.0f));
            matrices.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            if (drumBlock.m_58904_() != null) {
                int lightLevel = LevelRenderer.m_109541_((BlockAndTintGetter)drumBlock.m_58904_(), (BlockPos)drumBlock.m_58899_().m_121945_(direction));
                this.context.m_234447_().m_269128_(stack, ItemDisplayContext.FIXED, lightLevel, OverlayTexture.f_118083_, matrices, vertexConsumers, drumBlock.m_58904_(), ((Object)((Object)drumBlock)).hashCode());
            }
            matrices.m_85849_();
        }
        matrices.m_85836_();
        float width = this.context.m_173586_().m_92895_(text);
        float textScale = 0.007f;
        matrices.m_252880_(0.5f, 0.5f, 0.5f);
        matrices.m_252880_((float)direction.m_122429_() * 0.51f, (float)direction.m_122430_() * 0.51f, (float)direction.m_122431_() * 0.51f);
        matrices.m_252781_(Axis.f_252436_.m_252977_(-direction.m_122435_()));
        if (direction == Direction.UP || direction == Direction.DOWN) {
            matrices.m_252781_(Axis.f_252436_.m_252977_(direction == Direction.UP ? -90.0f : 90.0f));
            matrices.m_252781_(Axis.f_252529_.m_252977_(direction == Direction.UP ? -90.0f : 90.0f));
        }
        matrices.m_252880_(-(width * textScale) / 2.0f, 0.0f, 0.0f);
        matrices.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        matrices.m_252880_(0.0f, -0.2f, 0.0f);
        matrices.m_85841_(textScale, textScale, textScale);
        this.context.m_173586_().m_271703_(text, 0.0f, 0.0f, 0, false, matrices.m_85850_().m_252922_(), vertexConsumers, Font.DisplayMode.NORMAL, 0xFFFFFF, 0);
        matrices.m_85849_();
    }
}

