/*
 * Decompiled with CFR 0.152.
 */
package com.witchica.compactstorage.common.item;

import com.witchica.compactstorage.CompactStoragePlatform;
import com.witchica.compactstorage.common.inventory.BackpackInventory;
import com.witchica.compactstorage.common.screen.CompactChestScreenHandler;
import com.witchica.compactstorage.common.util.CompactStorageUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class BackpackItem
extends Item {
    public BackpackItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (!world.f_46443_) {
            boolean isInOffhand = hand == InteractionHand.OFF_HAND;
            ItemStack heldItemStack = player.m_21120_(hand);
            InteractionHand oppositeHand = hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
            ItemStack oppositeItemStack = player.m_21120_(oppositeHand);
            if (!heldItemStack.m_41782_()) {
                heldItemStack.m_41751_(new CompoundTag());
            }
            if (!oppositeItemStack.m_41619_()) {
                DyeItem dyeItem;
                Item newBackpackItem;
                Item oppositeItem = oppositeItemStack.m_41720_();
                BackpackInventory inventory = new BackpackInventory(heldItemStack.m_41783_().m_128469_("Backpack"), player, isInOffhand);
                if (hand == InteractionHand.MAIN_HAND && oppositeItem instanceof BackpackItem) {
                    return super.m_7203_(world, player, hand);
                }
                if (oppositeItem == CompactStoragePlatform.getStorageRowUpgradeItem()) {
                    if (inventory.increaseSize(1, 0)) {
                        player.m_21120_(oppositeHand).m_41774_(1);
                        heldItemStack.m_41783_().m_128365_("Backpack", (Tag)inventory.toTag());
                        player.m_5661_((Component)Component.m_237115_((String)"text.compact_storage.upgrade_success").m_130940_(ChatFormatting.GREEN), true);
                        player.m_6330_(SoundEvents.f_12275_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        return InteractionResultHolder.m_19098_((Object)heldItemStack);
                    }
                    player.m_6330_(SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    player.m_5661_((Component)Component.m_237115_((String)"text.compact_storage.upgrade_fail_maxsize").m_130940_(ChatFormatting.RED), true);
                    return InteractionResultHolder.m_19100_((Object)heldItemStack);
                }
                if (oppositeItem == CompactStoragePlatform.getStorageColumnUpgradeItem()) {
                    if (inventory.increaseSize(0, 1)) {
                        player.m_21120_(oppositeHand).m_41774_(1);
                        heldItemStack.m_41783_().m_128365_("Backpack", (Tag)inventory.toTag());
                        player.m_5661_((Component)Component.m_237115_((String)"text.compact_storage.upgrade_success").m_130940_(ChatFormatting.GREEN), true);
                        player.m_6330_(SoundEvents.f_12275_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        return InteractionResultHolder.m_19098_((Object)heldItemStack);
                    }
                    player.m_6330_(SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    player.m_5661_((Component)Component.m_237115_((String)"text.compact_storage.upgrade_fail_maxsize").m_130940_(ChatFormatting.RED), true);
                    return InteractionResultHolder.m_19100_((Object)heldItemStack);
                }
                if (oppositeItem instanceof DyeItem && (newBackpackItem = CompactStoragePlatform.getBackpackFromDyeColor((dyeItem = (DyeItem)oppositeItem).m_41089_())) != heldItemStack.m_41720_()) {
                    ItemStack newStack = new ItemStack((ItemLike)newBackpackItem, 1);
                    newStack.m_41751_(heldItemStack.m_41783_());
                    player.m_6330_(SoundEvents.f_12392_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    player.m_21120_(oppositeHand).m_41774_(1);
                    return InteractionResultHolder.m_19098_((Object)newStack);
                }
            }
            if (player.f_36096_ instanceof CompactChestScreenHandler) {
                ((ServerPlayer)player).m_6915_();
                return super.m_7203_(world, player, hand);
            }
            this.openMenu(player, hand);
        }
        return super.m_7203_(world, player, hand);
    }

    public abstract void openMenu(Player var1, InteractionHand var2);

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        super.m_7373_(stack, world, tooltip, context);
        CompactStorageUtil.appendTooltip(stack, (BlockGetter)world, tooltip, context, true);
    }
}

