/*
 * Decompiled with CFR 0.152.
 */
package com.witchica.compactstorage.common.util;

import com.witchica.compactstorage.common.util.CompactStorageInventoryImpl;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import org.jetbrains.annotations.Nullable;

public class CompactStorageUtil {
    public static final String[] DRUM_TYPES = new String[]{"acacia", "birch", "cherry", "crimson", "dark_oak", "jungle", "mangrove", "oak", "spruce", "warped"};

    public static void appendTooltip(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag options, boolean isBackpack) {
        int inventoryX = 9;
        int inventoryY = 6;
        CompoundTag compound = stack.m_41783_();
        if (isBackpack && compound != null) {
            compound = compound.m_128469_("Backpack");
        }
        if (compound != null && compound.m_128441_("inventory_width")) {
            inventoryX = compound.m_128451_("inventory_width");
            inventoryY = compound.m_128451_("inventory_height");
        }
        int slots = inventoryX * inventoryY;
        tooltip.add((Component)Component.m_237115_((String)"text.compact_storage.tooltip.size_x").m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237113_((String)("" + inventoryX)).m_130940_(ChatFormatting.DARK_PURPLE)));
        tooltip.add((Component)Component.m_237115_((String)"text.compact_storage.tooltip.size_y").m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237113_((String)("" + inventoryY)).m_130940_(ChatFormatting.DARK_PURPLE)));
        tooltip.add((Component)Component.m_237110_((String)"text.compact_storage.tooltip.slots", (Object[])new Object[]{slots}).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.ITALIC}));
    }

    public static void dropContents(Level world, BlockPos pos, Block block, Player player) {
        if (world.f_46443_) {
            return;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof CompactStorageInventoryImpl) {
            RandomizableContainerBlockEntity lootableContainerBlockEntity;
            CompactStorageInventoryImpl inventory = (CompactStorageInventoryImpl)blockEntity;
            ItemStack chestStack = new ItemStack((ItemLike)block, 1);
            CompoundTag chestTag = new CompoundTag();
            chestTag.m_128405_("inventory_width", inventory.getInventoryWidth());
            chestTag.m_128405_("inventory_height", inventory.getInventoryHeight());
            if (inventory.getInventoryWidth() != 9 || inventory.getInventoryHeight() != 6) {
                chestStack.m_41751_(chestTag);
            }
            if (inventory instanceof RandomizableContainerBlockEntity && (lootableContainerBlockEntity = (RandomizableContainerBlockEntity)inventory).m_8077_()) {
                chestStack.m_41714_(lootableContainerBlockEntity.m_7770_());
            }
            Containers.m_19002_((Level)world, (BlockPos)pos, (Container)((Container)inventory));
            if (player == null || !player.m_7500_()) {
                Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)chestStack);
            }
            world.m_46717_(pos, block);
        }
    }
}

