/*
 * Decompiled with CFR 0.152.
 */
package slexom.animal_feeding_trough.platform.common.mixin;

import java.util.Arrays;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import slexom.animal_feeding_trough.platform.common.goal.entity.ai.SelfFeedGoal;
import slexom.animal_feeding_trough.platform.common.mixin.GoalSelectorAccessor;
import slexom.animal_feeding_trough.platform.common.mixin.TemptGoalAccessor;

@Mixin(value={Animal.class})
public class AnimalEntityMixin
extends Mob {
    private static final ItemStack[] FORBIDDEN_ITEMS = (ItemStack[])Arrays.stream(new Item[]{Items.f_42684_, Items.f_42685_}).map(ItemStack::new).toArray(ItemStack[]::new);

    protected AnimalEntityMixin(EntityType<? extends Mob> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void AFTAddSelfFeedingGoal(EntityType<? extends Mob> entityType, Level world, CallbackInfo ci) {
        if (world != null && !world.f_46443_) {
            ((GoalSelectorAccessor)this.f_21345_).getGoals().stream().filter(prioritizedGoal -> prioritizedGoal.m_26015_().getClass().equals(TemptGoal.class)).toList().forEach(prioritizedGoal -> {
                TemptGoal goal = (TemptGoal)prioritizedGoal.m_26015_();
                PathfinderMob mob = ((TemptGoalAccessor)goal).getMob();
                double speed = ((TemptGoalAccessor)goal).getSpeed();
                Ingredient food = ((TemptGoalAccessor)goal).getFood();
                boolean hasForbiddenFood = false;
                for (ItemStack itemStack : FORBIDDEN_ITEMS) {
                    if (!food.test(itemStack)) continue;
                    hasForbiddenFood = true;
                    break;
                }
                if (!hasForbiddenFood) {
                    this.f_21345_.m_25352_(prioritizedGoal.m_26012_() + 1, (Goal)new SelfFeedGoal((Animal)mob, speed, food));
                }
            });
        }
    }
}

