/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdeserttemples.world.processor;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.betterdeserttemples.module.StructureProcessorModule;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SpongeProcessor
extends StructureProcessor {
    public static final SpongeProcessor INSTANCE = new SpongeProcessor();
    public static final Codec<SpongeProcessor> CODEC = Codec.unit(() -> INSTANCE);
    private static final List<Block> CANDLES = List.of(Blocks.f_152482_, Blocks.f_152483_, Blocks.f_152516_, Blocks.f_152517_, Blocks.f_152521_, Blocks.f_152484_);

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData) {
        Block block = blockInfoGlobal.f_74676_().m_60734_();
        if (block == Blocks.f_50056_ || block == Blocks.f_50057_ || block == Blocks.f_152482_) {
            RandomSource randomSource = structurePlacementData.m_230326_(blockInfoGlobal.f_74675_());
            if (randomSource.m_188501_() < 0.8f) {
                int numCandles = 1;
                float r = randomSource.m_188501_();
                if (r < 0.1f) {
                    numCandles = 2;
                } else if (r < 0.15f) {
                    numCandles = 3;
                } else if (r < 0.2f) {
                    numCandles = 4;
                }
                boolean lit = randomSource.m_188501_() < 0.4f;
                BlockState newBlockState = (BlockState)((BlockState)SpongeProcessor.getRandomCandle(randomSource).m_49966_().m_61124_((Property)CandleBlock.f_152790_, (Comparable)Integer.valueOf(numCandles))).m_61124_((Property)CandleBlock.f_152791_, (Comparable)Boolean.valueOf(lit));
                blockInfoGlobal = new StructureTemplate.StructureBlockInfo(blockInfoGlobal.f_74675_(), newBlockState, blockInfoGlobal.f_74677_());
            } else {
                blockInfoGlobal = new StructureTemplate.StructureBlockInfo(blockInfoGlobal.f_74675_(), Blocks.f_50016_.m_49966_(), null);
            }
        }
        return blockInfoGlobal;
    }

    private static Block getRandomCandle(RandomSource randomSource) {
        int i = randomSource.m_188503_(CANDLES.size());
        return CANDLES.get(i);
    }

    protected StructureProcessorType<?> m_6953_() {
        return StructureProcessorModule.SPONGE_PROCESSOR;
    }
}

