/*
 * Decompiled with CFR 0.152.
 */
package net.cristellib.builtinpacks;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.cristellib.CristelLib;
import net.cristellib.builtinpacks.UnsafeByteArrayOutputStream;
import net.cristellib.config.ConfigUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.FeatureFlagsMetadataSection;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.flag.FeatureFlags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RuntimePack
implements PackResources {
    public static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    private final Lock waiting = new ReentrantLock();
    private final Map<ResourceLocation, Supplier<byte[]>> data = new ConcurrentHashMap<ResourceLocation, Supplier<byte[]>>();
    private final Map<List<String>, Supplier<byte[]>> root = new ConcurrentHashMap<List<String>, Supplier<byte[]>>();
    public final int packVersion;
    private final String name;

    public RuntimePack(String name, int version, @Nullable Path imageFile) {
        byte[] image;
        this.packVersion = version;
        this.name = name;
        if (imageFile != null && (image = RuntimePack.extractImageBytes(imageFile)) != null) {
            this.addRootResource("pack.png", image);
        }
    }

    public byte[] addStructureSet(ResourceLocation identifier, JsonObject set) {
        return this.addDataForJsonLocation("worldgen/structure_set", identifier, set);
    }

    public byte[] addBiome(ResourceLocation identifier, JsonObject biome) {
        return this.addDataForJsonLocation("worldgen/biome", identifier, biome);
    }

    public byte[] addStructure(ResourceLocation identifier, JsonObject structure) {
        return this.addDataForJsonLocation("worldgen/structure", identifier, structure);
    }

    public byte[] addLootTable(ResourceLocation identifier, JsonObject table) {
        return this.addDataForJsonLocation("loot_tables", identifier, table);
    }

    public byte @Nullable [] addDataForJsonLocationFromPath(String prefix, ResourceLocation identifier, String fromSubPath, String fromModID) {
        JsonElement jsonElement = ConfigUtil.getElement(fromModID, fromSubPath);
        if (jsonElement instanceof JsonObject) {
            JsonObject object = (JsonObject)jsonElement;
            return this.addDataForJsonLocation(prefix, identifier, object);
        }
        return null;
    }

    public byte[] addDataForJsonLocation(String prefix, ResourceLocation identifier, JsonObject object) {
        return this.addAndSerializeDataForLocation(prefix, "json", identifier, object);
    }

    public byte[] addAndSerializeDataForLocation(String prefix, String end, ResourceLocation identifier, JsonObject object) {
        return this.addData(new ResourceLocation(identifier.m_135827_(), prefix + "/" + identifier.m_135815_() + "." + end), RuntimePack.serializeJson(object));
    }

    public byte[] addData(ResourceLocation path, byte[] data) {
        this.data.put(path, () -> data);
        return data;
    }

    public void removeData(ResourceLocation path) {
        this.data.remove(path);
    }

    public static byte @Nullable [] extractImageBytes(Path imageName) {
        try {
            InputStream stream = Files.newInputStream(imageName.toAbsolutePath(), new OpenOption[0]);
            return stream.readAllBytes();
        }
        catch (IOException e) {
            CristelLib.LOGGER.warn("Couldn't get image for path: " + imageName, (Throwable)e);
            return null;
        }
    }

    public static byte[] serializeJson(JsonObject object) {
        UnsafeByteArrayOutputStream ubaos = new UnsafeByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)ubaos, StandardCharsets.UTF_8);
        GSON.toJson((JsonElement)object, (Appendable)writer);
        try {
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ubaos.getBytes();
    }

    public byte[] addRootResource(String path, byte[] data) {
        this.root.put(Arrays.asList(path.split("/")), () -> data);
        return data;
    }

    @Nullable
    public IoSupplier<InputStream> m_8017_(String ... strings) {
        this.lock();
        Supplier<byte[]> supplier = this.root.get(Arrays.asList(strings));
        if (supplier == null) {
            this.waiting.unlock();
            return null;
        }
        this.waiting.unlock();
        return () -> new ByteArrayInputStream((byte[])supplier.get());
    }

    private void lock() {
        if (!this.waiting.tryLock()) {
            this.waiting.lock();
        }
    }

    @Nullable
    public IoSupplier<InputStream> m_214146_(@NotNull PackType packType, @NotNull ResourceLocation id) {
        this.lock();
        Supplier<byte[]> supplier = this.data.get(id);
        if (supplier == null) {
            this.waiting.unlock();
            return null;
        }
        this.waiting.unlock();
        return () -> new ByteArrayInputStream((byte[])supplier.get());
    }

    public void m_8031_(@NotNull PackType packType, @NotNull String namespace, @NotNull String prefix, @NotNull PackResources.ResourceOutput resourceOutput) {
        this.lock();
        for (ResourceLocation identifier : this.data.keySet()) {
            Supplier<byte[]> supplier = this.data.get(identifier);
            if (supplier == null) {
                this.waiting.unlock();
                continue;
            }
            if (!identifier.m_135827_().equals(namespace) || !identifier.m_135815_().contains(prefix + "/")) continue;
            IoSupplier inputSupplier = () -> new ByteArrayInputStream((byte[])supplier.get());
            resourceOutput.accept((Object)identifier, (Object)inputSupplier);
        }
        this.waiting.unlock();
    }

    @NotNull
    public Set<String> m_5698_(@NotNull PackType packType) {
        this.lock();
        HashSet<String> namespaces = new HashSet<String>();
        for (ResourceLocation identifier : this.data.keySet()) {
            namespaces.add(identifier.m_135827_());
        }
        this.waiting.unlock();
        return namespaces;
    }

    @Nullable
    public <T> T m_5550_(@NotNull MetadataSectionSerializer<T> metadataSectionSerializer) {
        InputStream stream = null;
        try {
            IoSupplier<InputStream> supplier = this.m_8017_("pack.mcmeta");
            if (supplier != null) {
                stream = (InputStream)supplier.m_247737_();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (stream != null) {
            return (T)FilePackResources.m_10214_(metadataSectionSerializer, (InputStream)stream);
        }
        if (metadataSectionSerializer.m_7991_().equals("pack")) {
            JsonObject object = new JsonObject();
            object.addProperty("pack_format", (Number)this.packVersion);
            object.addProperty("description", this.name);
            return (T)metadataSectionSerializer.m_6322_(object);
        }
        if (metadataSectionSerializer.m_7991_().equals("features")) {
            return (T)metadataSectionSerializer.m_6322_(FeatureFlagsMetadataSection.f_244642_.m_245162_((Object)new FeatureFlagsMetadataSection(FeatureFlags.f_244332_)));
        }
        CristelLib.LOGGER.debug("'" + metadataSectionSerializer.m_7991_() + "' is an unsupported metadata key");
        return null;
    }

    public boolean hasResource(ResourceLocation location) {
        return this.data.containsKey(location);
    }

    public boolean m_246538_() {
        return true;
    }

    @NotNull
    public String m_5542_() {
        return this.name;
    }

    public void close() {
        CristelLib.LOGGER.debug("Closing RDP: " + this.name);
    }

    public void load(Path dir) throws IOException {
        Stream<Path> stream = Files.walk(dir, new FileVisitOption[0]);
        for (Path file : () -> stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(dir::relativize).iterator()) {
            String s = file.toString();
            if (s.startsWith("data")) {
                String path = s.substring("data".length() + 1);
                this.load(path, this.data, Files.readAllBytes(file));
                continue;
            }
            if (s.startsWith("assets")) continue;
            byte[] data = Files.readAllBytes(file);
            this.root.put(Arrays.asList(s.split("/")), () -> data);
        }
    }

    public void load(ZipInputStream stream) throws IOException {
        ZipEntry entry;
        while ((entry = stream.getNextEntry()) != null) {
            String s = entry.toString();
            if (s.startsWith("data")) {
                String path = s.substring("data".length() + 1);
                this.load(path, this.data, this.read(entry, stream));
                continue;
            }
            if (s.startsWith("assets")) continue;
            byte[] data = this.read(entry, stream);
            this.root.put(Arrays.asList(s.split("/")), () -> data);
        }
    }

    protected byte[] read(ZipEntry entry, InputStream stream) throws IOException {
        byte[] data = new byte[Math.toIntExact(entry.getSize())];
        if (stream.read(data) != data.length) {
            throw new IOException("Zip stream was cut off! (maybe incorrect zip entry length? maybe u didn't flush your stream?)");
        }
        return data;
    }

    protected void load(String fullPath, Map<ResourceLocation, Supplier<byte[]>> map, byte[] data) {
        int sep = fullPath.indexOf(47);
        String namespace = fullPath.substring(0, sep);
        String path = fullPath.substring(sep + 1);
        map.put(new ResourceLocation(namespace, path), () -> data);
    }

    @Nullable
    public JsonObject getResource(ResourceLocation location) {
        JsonObject jsonObject;
        IoSupplier<InputStream> stream = this.m_214146_(PackType.SERVER_DATA, location);
        try {
            jsonObject = GsonHelper.m_13859_((Reader)new BufferedReader(new InputStreamReader((InputStream)stream.m_247737_())));
        }
        catch (IOException | NullPointerException ex) {
            CristelLib.LOGGER.error("Couldn't get JsonObject from location: " + location, (Throwable)ex);
            return null;
        }
        return jsonObject;
    }
}

