/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.takesapillage.client.model;

import com.izofar.takesapillage.entity.Skirmisher;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.AbstractIllager;

public class SkirmisherModel
extends HierarchicalModel<Skirmisher>
implements ArmedModel,
HeadedModel {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart left_arm;
    private final ModelPart right_arm;
    private final ModelPart left_leg;
    private final ModelPart right_leg;

    public SkirmisherModel(ModelPart root) {
        this.root = root;
        this.head = root.m_171324_("head");
        this.body = root.m_171324_("body");
        this.left_arm = root.m_171324_("left_arm");
        this.right_arm = root.m_171324_("right_arm");
        this.left_leg = root.m_171324_("left_leg");
        this.right_leg = root.m_171324_("right_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition partdefinition1 = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f), PartPose.f_171404_);
        partdefinition1.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-0.5f, -15.0f, -5.0f, 1.0f, 6.0f, 10.0f, new CubeDeformation(-0.5f)), PartPose.f_171404_);
        partdefinition1.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171481_(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 20).m_171481_(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f).m_171514_(0, 38).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 18.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.f_171404_);
        partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)0.0f));
        partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171480_().m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)0.0f));
        partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171481_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171480_().m_171481_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void setupAnim(Skirmisher skirmisher, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        if (this.f_102609_) {
            this.right_arm.f_104203_ = -0.62831855f;
            this.right_arm.f_104204_ = 0.0f;
            this.right_arm.f_104205_ = 0.0f;
            this.left_arm.f_104203_ = -0.62831855f;
            this.left_arm.f_104204_ = 0.0f;
            this.left_arm.f_104205_ = 0.0f;
            this.right_leg.f_104203_ = -1.4137167f;
            this.right_leg.f_104204_ = 0.31415927f;
            this.right_leg.f_104205_ = 0.07853982f;
            this.left_leg.f_104203_ = -1.4137167f;
            this.left_leg.f_104204_ = -0.31415927f;
            this.left_leg.f_104205_ = -0.07853982f;
        } else {
            this.right_arm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
            this.right_arm.f_104204_ = 0.0f;
            this.right_arm.f_104205_ = 0.0f;
            this.left_arm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
            this.left_arm.f_104204_ = 0.0f;
            this.left_arm.f_104205_ = 0.0f;
            this.right_leg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
            this.right_leg.f_104204_ = 0.0f;
            this.right_leg.f_104205_ = 0.0f;
            this.left_leg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
            this.left_leg.f_104204_ = 0.0f;
            this.left_leg.f_104205_ = 0.0f;
        }
        AbstractIllager.IllagerArmPose abstractillager$illagerarmpose = skirmisher.m_6768_();
        if (abstractillager$illagerarmpose == AbstractIllager.IllagerArmPose.ATTACKING) {
            if (!skirmisher.m_21205_().m_41619_()) {
                AnimationUtils.m_102091_((ModelPart)this.right_arm, (ModelPart)this.left_arm, (Mob)skirmisher, (float)this.f_102608_, (float)ageInTicks);
            }
        } else if (abstractillager$illagerarmpose == AbstractIllager.IllagerArmPose.SPELLCASTING) {
            this.right_arm.f_104202_ = 0.0f;
            this.right_arm.f_104200_ = -5.0f;
            this.left_arm.f_104202_ = 0.0f;
            this.left_arm.f_104200_ = 5.0f;
            this.right_arm.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
            this.left_arm.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
            this.right_arm.f_104205_ = 2.3561945f;
            this.left_arm.f_104205_ = -2.3561945f;
            this.right_arm.f_104204_ = 0.0f;
            this.left_arm.f_104204_ = 0.0f;
        } else if (abstractillager$illagerarmpose == AbstractIllager.IllagerArmPose.BOW_AND_ARROW) {
            this.right_arm.f_104204_ = -0.1f + this.head.f_104204_;
            this.right_arm.f_104203_ = -1.5707964f + this.head.f_104203_;
            this.left_arm.f_104203_ = -0.9424779f + this.head.f_104203_;
            this.head.f_104204_ -= 0.4f;
            this.left_arm.f_104205_ = 1.5707964f;
        } else if (abstractillager$illagerarmpose == AbstractIllager.IllagerArmPose.CROSSBOW_HOLD) {
            AnimationUtils.m_102097_((ModelPart)this.right_arm, (ModelPart)this.left_arm, (ModelPart)this.head, (boolean)true);
        } else if (abstractillager$illagerarmpose == AbstractIllager.IllagerArmPose.CROSSBOW_CHARGE) {
            AnimationUtils.m_102086_((ModelPart)this.right_arm, (ModelPart)this.left_arm, (LivingEntity)skirmisher, (boolean)true);
        } else if (abstractillager$illagerarmpose == AbstractIllager.IllagerArmPose.CELEBRATING) {
            this.right_arm.f_104202_ = 0.0f;
            this.right_arm.f_104200_ = -5.0f;
            this.right_arm.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.05f;
            this.right_arm.f_104205_ = 2.670354f;
            this.right_arm.f_104204_ = 0.0f;
            this.left_arm.f_104202_ = 0.0f;
            this.left_arm.f_104200_ = 5.0f;
            this.left_arm.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.05f;
            this.left_arm.f_104205_ = -2.3561945f;
            this.left_arm.f_104204_ = 0.0f;
        }
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.left_arm : this.right_arm;
    }

    public ModelPart m_5585_() {
        return this.head;
    }

    public void m_6002_(HumanoidArm arm, PoseStack stack) {
        this.getArm(arm).m_104299_(stack);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.head.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.body.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.left_arm.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.right_arm.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.left_leg.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.right_leg.m_104301_(poseStack, buffer, packedLight, packedOverlay);
    }
}

