/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.takesapillage.entity;

import com.izofar.takesapillage.entity.IShieldedMob;
import com.izofar.takesapillage.entity.ai.ShieldGoal;
import com.izofar.takesapillage.init.ModSoundEvents;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class Legioner
extends AbstractIllager
implements IShieldedMob {
    private static final EntityDataAccessor<Boolean> DATA_IS_SHIELDED = SynchedEntityData.m_135353_(Legioner.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_SHIELD_HAND = SynchedEntityData.m_135353_(Legioner.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_SHIELD_COOLDOWN = SynchedEntityData.m_135353_(Legioner.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UUID SPEED_MODIFIER_ATTACKING_UUID = UUID.fromString("3520BCE0-D755-458F-944B-A528DB8EF9DC");
    private static final AttributeModifier SPEED_MODIFIER_BLOCKING = new AttributeModifier(SPEED_MODIFIER_ATTACKING_UUID, "Shielded speed penalty", -0.1, AttributeModifier.Operation.ADDITION);

    public Legioner(EntityType<? extends AbstractIllager> entitytype, Level world) {
        super(entitytype, world);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.275).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22281_, 6.5).m_22268_(Attributes.f_22284_, 6.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, new ShieldGoal<Legioner>(this, Player.class));
        this.f_21345_.m_25352_(2, (Goal)new AbstractIllager.RaiderOpenDoorGoal((AbstractIllager)this, (Raider)this));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.25, true));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_SHIELDED, (Object)false);
        this.f_19804_.m_135372_(DATA_SHIELD_HAND, (Object)false);
        this.f_19804_.m_135372_(DATA_SHIELD_COOLDOWN, (Object)0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.decrementShieldCooldown();
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelaccessor, DifficultyInstance difficulty, MobSpawnType spawntype, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        SpawnGroupData spawngroupdata = super.m_6518_(levelaccessor, difficulty, spawntype, data, tag);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        RandomSource randomsource = levelaccessor.m_213780_();
        this.m_213945_(randomsource, difficulty);
        this.m_213946_(randomsource, difficulty);
        return spawngroupdata;
    }

    protected void m_213945_(RandomSource randomsource, DifficultyInstance difficulty) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42383_));
        this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42740_));
    }

    public boolean m_7307_(Entity entity) {
        LivingEntity livingEntity;
        if (super.m_7307_(entity)) {
            return true;
        }
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && entity.m_5647_() == null;
        }
        return false;
    }

    public AbstractIllager.IllagerArmPose m_6768_() {
        if (this.m_5912_()) {
            return AbstractIllager.IllagerArmPose.ATTACKING;
        }
        return this.m_37888_() ? AbstractIllager.IllagerArmPose.CELEBRATING : null;
    }

    public void m_7895_(int round, boolean b) {
    }

    public void m_147240_(double x, double y, double z) {
        if (!this.isUsingShield()) {
            super.m_147240_(x, y, z);
        } else {
            this.m_5496_(SoundEvents.f_12346_, 1.0f, 0.8f + this.m_9236_().f_46441_.m_188501_() * 0.4f);
        }
    }

    protected void m_6728_(LivingEntity attacker) {
        super.m_6728_(attacker);
        if (attacker.m_21205_().canDisableShield(this.f_20935_, (LivingEntity)this, attacker)) {
            this.disableShield();
        }
    }

    private void disableShield() {
        this.setShieldCooldown(60);
        this.stopUsingShield();
        this.m_9236_().m_7605_((Entity)this, (byte)30);
        this.m_5496_(SoundEvents.f_12347_, 0.8f, 0.8f + this.m_9236_().f_46441_.m_188501_() * 0.4f);
    }

    @Override
    public boolean isShieldDisabled() {
        return this.getShieldCooldown() > 0;
    }

    @Override
    public void startUsingShield() {
        if (this.isUsingShield() || this.isShieldDisabled()) {
            return;
        }
        for (InteractionHand interactionhand : InteractionHand.values()) {
            if (!this.m_21120_(interactionhand).m_150930_(Items.f_42740_)) continue;
            this.m_6672_(interactionhand);
            this.setUsingShield(true);
            this.setShieldMainhand(interactionhand == InteractionHand.MAIN_HAND);
            AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22279_);
            if (attributeinstance == null || attributeinstance.m_22109_(SPEED_MODIFIER_BLOCKING)) continue;
            attributeinstance.m_22118_(SPEED_MODIFIER_BLOCKING);
        }
    }

    @Override
    public void stopUsingShield() {
        if (!this.isUsingShield()) {
            return;
        }
        for (InteractionHand interactionhand : InteractionHand.values()) {
            if (!this.m_21120_(interactionhand).m_150930_(Items.f_42740_)) continue;
            this.m_5810_();
            this.setUsingShield(false);
            AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22279_);
            if (attributeinstance == null) continue;
            attributeinstance.m_22130_(SPEED_MODIFIER_BLOCKING);
        }
    }

    public boolean isUsingShield() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_SHIELDED);
    }

    public void setUsingShield(boolean isShielded) {
        this.f_19804_.m_135381_(DATA_IS_SHIELDED, (Object)isShielded);
    }

    private boolean isShieldMainhand() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SHIELD_HAND);
    }

    private void setShieldMainhand(boolean isShieldedMainHand) {
        this.f_19804_.m_135381_(DATA_SHIELD_HAND, (Object)isShieldedMainHand);
    }

    private int getShieldCooldown() {
        return (Integer)this.f_19804_.m_135370_(DATA_SHIELD_COOLDOWN);
    }

    private void setShieldCooldown(int newShieldCooldown) {
        this.f_19804_.m_135381_(DATA_SHIELD_COOLDOWN, (Object)newShieldCooldown);
    }

    private void decrementShieldCooldown() {
        this.setShieldCooldown(Math.max(this.getShieldCooldown() - 1, 0));
    }

    public InteractionHand getShieldHand() {
        return this.isUsingShield() ? (this.isShieldMainhand() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND) : null;
    }

    public SoundEvent m_7930_() {
        return (SoundEvent)ModSoundEvents.LEGIONER_CELEBRATE.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.LEGIONER_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.LEGIONER_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource p_33306_) {
        return (SoundEvent)ModSoundEvents.LEGIONER_HURT.get();
    }
}

