/*
 * Decompiled with CFR 0.152.
 */
package ace.actually.pirates;

import ace.actually.pirates.blocks.CannonPrimingBlock;
import ace.actually.pirates.blocks.CrewSpawnerBlock;
import ace.actually.pirates.blocks.DispenserCannonBlock;
import ace.actually.pirates.blocks.MotionInvokingBlock;
import ace.actually.pirates.blocks.StableBlock;
import ace.actually.pirates.blocks.entity.CannonPrimingBlockEntity;
import ace.actually.pirates.blocks.entity.CrewSpawnerBlockEntity;
import ace.actually.pirates.blocks.entity.MotionInvokingBlockEntity;
import ace.actually.pirates.blocks.entity.StableBlockEntity;
import ace.actually.pirates.entities.pirate_default.PirateEntity;
import ace.actually.pirates.entities.pirate_skeleton.SkeletonPirateEntity;
import ace.actually.pirates.entities.shot.ShotEntity;
import ace.actually.pirates.events.IPirateDies;
import ace.actually.pirates.items.ShipPointer;
import ace.actually.pirates.sound.ModSounds;
import ace.actually.pirates.util.ConfigUtils;
import ace.actually.pirates.util.PatternProcessor;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleFactory;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleRegistry;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_4048;
import net.minecraft.class_4970;
import net.minecraft.class_5132;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pirates
implements ModInitializer {
    public static final String MOD_ID = "pirates";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"pirates");
    public static final class_1928.class_4313<class_1928.class_4310> PIRATES_IS_LIVE_WORLD = GameRuleRegistry.register((String)"piratesIsLive", (class_1928.class_5198)class_1928.class_5198.field_24100, (class_1928.class_4314)GameRuleFactory.createBooleanRule((boolean)true));
    public static final class_5321<class_1761> PIRATES_ITEM_GROUP_KEY = class_5321.method_29179((class_5321)class_7923.field_44687.method_30517(), (class_2960)class_2960.method_43902((String)"pirates", (String)"item_group"));
    public static final class_1761 PIRATES_ITEM_GROUP = FabricItemGroup.builder().method_47320(() -> new class_1799((class_1935)CANNONBALL)).method_47321(class_2561.method_30163((String)"Valkyrien Pirates")).method_47324();
    private static final class_2498 Silent = new class_2498(0.0f, 0.0f, class_3417.field_15083, class_3417.field_15083, class_3417.field_15083, class_3417.field_15083, class_3417.field_15083);
    public static final MotionInvokingBlock MOTION_INVOKING_BLOCK = new MotionInvokingBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10307).method_45477().method_36557(7.0f).method_42327());
    public static final CannonPrimingBlock CANNON_PRIMING_BLOCK = new CannonPrimingBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10200).method_36557(5.0f));
    public static final DispenserCannonBlock DISPENSER_CANNON_BLOCK = new DispenserCannonBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10200).method_36557(5.0f));
    public static final CrewSpawnerBlock CREW_SPAWNER_BLOCK = new CrewSpawnerBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10307).method_45477().method_9634().method_42327().method_9626(Silent));
    public static final StableBlock STABLE_BLOCK = new StableBlock(class_4970.class_2251.method_9637());
    public static final class_1792 CANNONBALL = new class_1792(new class_1792.class_1793());
    public static final class_1792 CANNONBALL_ENT = new class_1792(new class_1792.class_1793());
    public static final ShipPointer SHIP_POINTER = new ShipPointer(new class_1792.class_1793());
    public static final class_2591<MotionInvokingBlockEntity> MOTION_INVOKING_BLOCK_ENTITY = (class_2591)class_2378.method_10230((class_2378)class_7923.field_41181, (class_2960)new class_2960("pirates", "motion_invoking_block_entity"), (Object)FabricBlockEntityTypeBuilder.create(MotionInvokingBlockEntity::new, (class_2248[])new class_2248[]{MOTION_INVOKING_BLOCK}).build());
    public static final class_2591<CannonPrimingBlockEntity> CANNON_PRIMING_BLOCK_ENTITY = (class_2591)class_2378.method_10230((class_2378)class_7923.field_41181, (class_2960)new class_2960("pirates", "cannon_priming_block_entity"), (Object)FabricBlockEntityTypeBuilder.create(CannonPrimingBlockEntity::new, (class_2248[])new class_2248[]{CANNON_PRIMING_BLOCK}).build());
    public static final class_2591<CrewSpawnerBlockEntity> CREW_SPAWNER_BLOCK_ENTITY = (class_2591)class_2378.method_10230((class_2378)class_7923.field_41181, (class_2960)new class_2960("pirates", "crew_spawner_block_entity"), (Object)FabricBlockEntityTypeBuilder.create(CrewSpawnerBlockEntity::new, (class_2248[])new class_2248[]{CREW_SPAWNER_BLOCK}).build());
    public static final class_2591<StableBlockEntity> STABLE_BLOCK_ENTITY = (class_2591)class_2378.method_10230((class_2378)class_7923.field_41181, (class_2960)new class_2960("pirates", "stable_block_entity"), (Object)FabricBlockEntityTypeBuilder.create(StableBlockEntity::new, (class_2248[])new class_2248[]{STABLE_BLOCK}).build());
    public static final class_1299<ShotEntity> SHOT_ENTITY_TYPE = Pirates.registerEntity("shot", class_1311.field_17715, class_4048.method_18384((float)0.5f, (float)0.5f), (type, world) -> new ShotEntity(world));
    public static final class_1299<PirateEntity> PIRATE_ENTITY_TYPE = Pirates.registerEntity("pirate", class_1311.field_17715, class_4048.method_18384((float)0.6f, (float)1.9f), (type, world) -> new PirateEntity(world));
    public static final class_1299<SkeletonPirateEntity> SKELETON_PIRATE_ENTITY_TYPE = Pirates.registerEntity("skeleton_pirate", class_1311.field_17715, class_4048.method_18384((float)0.6f, (float)1.9f), (type, world) -> new SkeletonPirateEntity(world));

    public void onInitialize() {
        ConfigUtils.checkConfigs();
        this.registerEntityThings();
        this.registerBlocks();
        this.registerItems();
        PatternProcessor.setupBasicPatterns();
        ModSounds.registerSounds();
        LOGGER.info("Let there be motion!");
        class_2378.method_39197((class_2378)class_7923.field_44687, PIRATES_ITEM_GROUP_KEY, (Object)PIRATES_ITEM_GROUP);
        ItemGroupEvents.modifyEntriesEvent(PIRATES_ITEM_GROUP_KEY).register(itemGroup -> {
            itemGroup.method_45421((class_1935)CANNONBALL);
            itemGroup.method_45421((class_1935)CANNON_PRIMING_BLOCK.method_8389());
            itemGroup.method_45421((class_1935)CREW_SPAWNER_BLOCK.method_8389());
            itemGroup.method_45421((class_1935)MOTION_INVOKING_BLOCK.method_8389());
        });
        IPirateDies.EVENT.register((player, pirate) -> {
            System.out.println(pirate.method_5845());
            return class_1269.field_5811;
        });
    }

    private void registerEntityThings() {
        FabricDefaultAttributeRegistry.register(PIRATE_ENTITY_TYPE, (class_5132.class_5133)PirateEntity.attributes());
        FabricDefaultAttributeRegistry.register(SKELETON_PIRATE_ENTITY_TYPE, (class_5132.class_5133)SkeletonPirateEntity.attributes());
    }

    private void registerBlocks() {
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)new class_2960(MOD_ID, "cannon_priming_block"), (Object)((Object)CANNON_PRIMING_BLOCK));
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)new class_2960(MOD_ID, "motion_invoking_block"), (Object)((Object)MOTION_INVOKING_BLOCK));
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)new class_2960(MOD_ID, "dispenser_cannon_block"), (Object)((Object)DISPENSER_CANNON_BLOCK));
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)new class_2960(MOD_ID, "crew_spawner_block"), (Object)((Object)CREW_SPAWNER_BLOCK));
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)new class_2960(MOD_ID, "stable_block"), (Object)((Object)STABLE_BLOCK));
    }

    private void registerItems() {
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960(MOD_ID, "cannonball"), (Object)CANNONBALL);
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960("util_pirates", "util_1"), (Object)CANNONBALL_ENT);
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960(MOD_ID, "ship_pointer"), (Object)((Object)SHIP_POINTER));
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960(MOD_ID, "stable_block"), (Object)new class_1747((class_2248)STABLE_BLOCK, new class_1792.class_1793()));
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960(MOD_ID, "cannon_priming_block"), (Object)new class_1747((class_2248)CANNON_PRIMING_BLOCK, new class_1792.class_1793()));
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960(MOD_ID, "motion_invoking_block"), (Object)new class_1747((class_2248)MOTION_INVOKING_BLOCK, new class_1792.class_1793()));
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960(MOD_ID, "crew_spawner_block"), (Object)new class_1747((class_2248)CREW_SPAWNER_BLOCK, new class_1792.class_1793()));
    }

    public static <T extends class_1297> class_1299<T> registerEntity(String name, class_1311 category, class_4048 size, class_1299.class_4049<T> factory) {
        return (class_1299)class_2378.method_10230((class_2378)class_7923.field_41177, (class_2960)new class_2960(MOD_ID, name), (Object)FabricEntityTypeBuilder.create((class_1311)category, factory).dimensions(size).build());
    }
}

