/*
 * Decompiled with CFR 0.152.
 */
package ace.actually.pirates.structures;

import ace.actually.pirates.Pirates;
import ace.actually.pirates.structures.CanRemoveTemplate;
import java.util.HashSet;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import kotlin.Triple;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3218;
import net.minecraft.class_3485;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

public class ShipStructurePlacementHelper {
    public static final Queue<Triple<class_3499, class_3218, class_2338>> shipQueue = new ArrayBlockingQueue<Triple<class_3499, class_3218, class_2338>>(12, false);
    private static final Set<class_2338> blacklist = new HashSet<class_2338>();

    public static void placeShipTemplate(class_3499 structureTemplate, class_3218 world, class_2338 centrePos) {
        shipQueue.add((Triple<class_3499, class_3218, class_2338>)new Triple((Object)structureTemplate, (Object)world, (Object)centrePos));
        Pirates.LOGGER.info("enqueuing template at {}", (Object)centrePos.toString());
    }

    public static void createShip(class_3499 structureTemplate, class_3218 world, class_2338 blockPos) {
        if (blacklist.contains(blockPos)) {
            return;
        }
        blacklist.add(blockPos);
        ServerShip newShip = VSGameUtilsKt.getShipObjectWorld((class_3218)world).createNewShipAtBlock((Vector3ic)VectorConversionsMCKt.toJOML((class_2382)ShipStructurePlacementHelper.withOceanYLevel(world, blockPos).method_10086(structureTemplate.method_15160().method_10264() / 7)), false, 1.0, VSGameUtilsKt.getDimensionId((class_1937)world));
        newShip.setStatic(true);
        class_2338 centerPos = VectorConversionsMCKt.toBlockPos((Vector3ic)newShip.getChunkClaim().getCenterBlockCoordinates(VSGameUtilsKt.getYRange((class_1937)world), new Vector3i()));
        class_3492 structurePlacementData = new class_3492();
        structurePlacementData.method_15119(centerPos);
        boolean success = structureTemplate.method_15172((class_5425)world, centerPos, centerPos, structurePlacementData, class_5819.method_43047(), 2);
        Pirates.LOGGER.info("new ship id: {} mass: {}", (Object)newShip.getId(), (Object)newShip.getInertiaData().getMass());
        Pirates.LOGGER.info("Template claims to have generated successfully? {}", (Object)success);
        if (newShip.getInertiaData().getMass() < 0.1) {
            System.out.println("deleting ship");
            VSGameUtilsKt.getShipObjectWorld((class_3218)world).deleteShip(newShip);
        } else {
            Pirates.LOGGER.info("ship created successfully.");
            class_3485 manager = Objects.requireNonNull(world.method_8503()).method_27727();
            if (((CanRemoveTemplate)manager).pirates$unload(structureTemplate)) {
                Pirates.LOGGER.info("templates cleaned.");
            } else {
                Pirates.LOGGER.info("template cleanup failed.");
            }
        }
    }

    private static class_2338 withOceanYLevel(class_3218 world, class_2338 source) {
        return new class_2338(source.method_10263(), world.method_8615(), source.method_10260());
    }
}

