/*
 * Decompiled with CFR 0.152.
 */
package ace.actually.pirates.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.io.FileUtils;

public class ConfigUtils {
    public static Map<String, String> config = new HashMap<String, String>();

    public static Map<String, String> loadConfigs() {
        File file = new File(FabricLoader.getInstance().getConfigDir().toString() + "/pirates/config.acfg");
        try {
            List lines = FileUtils.readLines((File)file, (String)"utf-8");
            lines.forEach(line -> {
                if (line.charAt(0) != '#') {
                    String noSpace = line.replace(" ", "");
                    String[] entry = noSpace.split("=");
                    config.put(entry[0], entry[1]);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return config;
    }

    public static void generateConfigs(List<String> input) {
        File file = new File(FabricLoader.getInstance().getConfigDirectory().getPath() + "/pirates/config.acfg");
        try {
            FileUtils.writeLines((File)file, input);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Map<String, String> checkConfigs() {
        if (new File(FabricLoader.getInstance().getConfigDirectory().getPath() + "/pirates/config.acfg").exists()) {
            return ConfigUtils.loadConfigs();
        }
        ConfigUtils.generateConfigs(ConfigUtils.makeDefaults());
        return ConfigUtils.loadConfigs();
    }

    private static List<String> makeDefaults() {
        ArrayList<String> defaults = new ArrayList<String>();
        defaults.add("#general config for Valkyrien Pirates");
        defaults.add("cannon-firing-pause=40");
        defaults.add("#The max amount of blocks for the new ship builder, set to -1 to use the Eureka/VS version");
        defaults.add("max-ship-blocks=-1");
        defaults.add("#how many ticks should it take for an NPC controlled ship to change its target position, default 50");
        defaults.add("controlled-ship-updates=100");
        return defaults;
    }
}

