/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.api.world.randomize;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.yungsapi.YungsApiCommon;
import com.yungnickyoung.minecraft.yungsapi.world.structure.condition.StructureCondition;
import com.yungnickyoung.minecraft.yungsapi.world.structure.condition.StructureConditionType;
import com.yungnickyoung.minecraft.yungsapi.world.structure.context.StructureContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class BlockStateRandomizer {
    public static final Codec<BlockStateRandomizer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Entry.CODEC.listOf().fieldOf("entries").forGetter(randomizer -> randomizer.entries), (App)BlockState.f_61039_.fieldOf("defaultBlockState").forGetter(randomizer -> randomizer.defaultBlockState)).apply((Applicative)instance, BlockStateRandomizer::new));
    private List<Entry> entries = new ArrayList<Entry>();
    private BlockState defaultBlockState = Blocks.f_50016_.m_49966_();

    public CompoundTag saveTag() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128405_("defaultBlockStateId", Block.f_49791_.m_7447_((Object)this.defaultBlockState));
        ListTag entriesTag = (ListTag)Util.m_137469_((Object)new ListTag(), tag -> this.entries.forEach(entry -> {
            CompoundTag entryTag = new CompoundTag();
            entryTag.m_128405_("entryBlockStateId", Block.f_49791_.m_7447_((Object)entry.blockState));
            entryTag.m_128350_("entryChance", entry.probability);
            tag.add((Object)entryTag);
        }));
        compoundTag.m_128365_("entries", (Tag)entriesTag);
        return compoundTag;
    }

    public BlockStateRandomizer(CompoundTag compoundTag) {
        this.defaultBlockState = (BlockState)Block.f_49791_.m_7942_(compoundTag.m_128451_("defaultBlockStateId"));
        this.entries = new ArrayList<Entry>();
        ListTag entriesTag = compoundTag.m_128437_("entries", 10);
        entriesTag.forEach(entryTag -> {
            CompoundTag entryCompoundTag = (CompoundTag)entryTag;
            BlockState blockState = (BlockState)Block.f_49791_.m_7942_(entryCompoundTag.m_128451_("entryBlockStateId"));
            float chance = entryCompoundTag.m_128457_("entryChance");
            this.addBlock(blockState, chance);
        });
    }

    public BlockStateRandomizer(Map<BlockState, Float> entries, BlockState defaultBlockState) {
        this.entries = new ArrayList<Entry>();
        entries.forEach(this::addBlock);
        this.defaultBlockState = defaultBlockState;
    }

    public BlockStateRandomizer(List<Entry> entries, BlockState defaultBlockState) {
        this.entries = entries;
        this.defaultBlockState = defaultBlockState;
    }

    public BlockStateRandomizer(BlockState defaultBlockState) {
        this.defaultBlockState = defaultBlockState;
    }

    public BlockStateRandomizer() {
    }

    public static BlockStateRandomizer from(BlockState ... blockStates) {
        BlockStateRandomizer randomizer = new BlockStateRandomizer();
        float chance = 1.0f / (float)blockStates.length;
        for (BlockState state : blockStates) {
            randomizer.addBlock(state, chance);
        }
        return randomizer;
    }

    public BlockStateRandomizer addBlock(BlockState blockState, float chance) {
        if (this.entries.stream().anyMatch(entry -> entry.blockState.equals(blockState))) {
            YungsApiCommon.LOGGER.warn("WARNING: duplicate block {} added to BlockStateRandomizer!", (Object)blockState.toString());
            return this;
        }
        float currTotal = this.entries.stream().map(entry -> Float.valueOf(entry.probability)).reduce(Float::sum).orElse(Float.valueOf(0.0f)).floatValue();
        float newTotal = currTotal + chance;
        if (newTotal > 1.0f) {
            YungsApiCommon.LOGGER.warn("WARNING: block {} added to BlockStateRandomizer exceeds max probabiltiy of 1!", (Object)blockState.toString());
            return this;
        }
        this.entries.add(new Entry(blockState, chance));
        return this;
    }

    public BlockState get(Random random) {
        float target = random.nextFloat();
        float currBottom = 0.0f;
        for (Entry entry : this.entries) {
            if (currBottom <= target && target < currBottom + entry.probability) {
                return entry.blockState;
            }
            currBottom += entry.probability;
        }
        return this.defaultBlockState;
    }

    public BlockState get(RandomSource randomSource) {
        float target = randomSource.m_188501_();
        float currBottom = 0.0f;
        for (Entry entry : this.entries) {
            if (currBottom <= target && target < currBottom + entry.probability) {
                return entry.blockState;
            }
            currBottom += entry.probability;
        }
        return this.defaultBlockState;
    }

    public BlockState get(RandomSource randomSource, StructureContext ctx) {
        float target = randomSource.m_188501_();
        float currBottom = 0.0f;
        for (Entry entry : this.entries) {
            if (currBottom <= target && target < currBottom + entry.probability && entry.passesCondition(ctx)) {
                return entry.blockState;
            }
            currBottom += entry.probability;
        }
        return this.defaultBlockState;
    }

    public void setDefaultBlockState(BlockState blockState) {
        this.defaultBlockState = blockState;
    }

    public Map<BlockState, Float> getEntriesAsMap() {
        HashMap<BlockState, Float> map = new HashMap<BlockState, Float>();
        this.entries.forEach(entry -> map.put(entry.blockState, Float.valueOf(entry.probability)));
        return map;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public BlockState getDefaultBlockState() {
        return this.defaultBlockState;
    }

    public static class Entry {
        public static Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.f_61039_.fieldOf("blockState").forGetter(entry -> entry.blockState), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(entry -> Float.valueOf(entry.probability)), (App)StructureConditionType.CONDITION_CODEC.optionalFieldOf("condition").forGetter(entry -> entry.condition)).apply((Applicative)instance, Entry::new));
        public BlockState blockState;
        public float probability;
        public Optional<StructureCondition> condition;

        public Entry(BlockState blockState, float probability) {
            this.blockState = blockState;
            this.probability = probability;
        }

        public Entry(BlockState blockState, float probability, Optional<StructureCondition> condition) {
            this.blockState = blockState;
            this.probability = probability;
            this.condition = condition;
        }

        public boolean passesCondition(StructureContext ctx) {
            return this.condition.isEmpty() || this.condition.get().passes(ctx);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Entry) {
                return this.blockState.equals(((Entry)obj).blockState);
            }
            if (obj instanceof BlockState) {
                return this.blockState.equals(obj);
            }
            return false;
        }
    }
}

