/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.config;

import com.github.imifou.jsonschema.module.addon.annotation.JsonSchema;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.valkyrienskies.core.impl.config.PhysicsConfig;
import org.valkyrienskies.core.impl.shadow.bm;
import org.valkyrienskies.core.impl.shadow.bn;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0007\bB\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004"}, d2={"Lorg/valkyrienskies/core/impl/config/VSCoreConfig;", "", "Lorg/valkyrienskies/core/impl/config/VSCoreConfig$Server;", "SERVER", "Lorg/valkyrienskies/core/impl/config/VSCoreConfig$Server;", "<init>", "()V", "Server", "ServerConfigModule"})
public final class VSCoreConfig {
    public static final VSCoreConfig INSTANCE = new VSCoreConfig();
    public static final Server SERVER = new Server();

    private VSCoreConfig() {
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0001(B\u0007\u00a2\u0006\u0004\b&\u0010'R\"\u0010\u0003\u001a\u00020\u00028\u0007@\u0007X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\"\u0010\n\u001a\u00020\t8\u0007@\u0007X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0011\u001a\u00020\u00108\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\"\u0010\u0016\u001a\u00020\u00158\u0007@\u0007X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\"\u0010\u001c\u001a\u00020\u00158\u0007@\u0007X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u0017\u001a\u0004\b\u001d\u0010\u0019\"\u0004\b\u001e\u0010\u001bR\"\u0010 \u001a\u00020\u001f8\u0007@\u0007X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%"}, d2={"Lorg/valkyrienskies/core/impl/config/VSCoreConfig$Server;", "", "", "enableUdp", "Z", "getEnableUdp", "()Z", "setEnableUdp", "(Z)V", "Lorg/valkyrienskies/core/impl/config/PhysicsConfig;", "physics", "Lorg/valkyrienskies/core/impl/config/PhysicsConfig;", "getPhysics", "()Lorg/valkyrienskies/core/impl/config/PhysicsConfig;", "setPhysics", "(Lorg/valkyrienskies/core/impl/config/PhysicsConfig;)V", "Lorg/valkyrienskies/core/impl/config/VSCoreConfig$Server$PhysicsThreadSettings;", "pt", "Lorg/valkyrienskies/core/impl/config/VSCoreConfig$Server$PhysicsThreadSettings;", "getPt", "()Lorg/valkyrienskies/core/impl/config/VSCoreConfig$Server$PhysicsThreadSettings;", "", "shipLoadDistance", "D", "getShipLoadDistance", "()D", "setShipLoadDistance", "(D)V", "shipUnloadDistance", "getShipUnloadDistance", "setShipUnloadDistance", "", "udpPort", "I", "getUdpPort", "()I", "setUdpPort", "(I)V", "<init>", "()V", "PhysicsThreadSettings"})
    public static final class Server {
        @JsonSchema(title="Physics Thread Settings")
        private final PhysicsThreadSettings pt = new PhysicsThreadSettings();
        @JsonSchema(description="Port to attempt to establish UDP connections on")
        private int udpPort = 25565;
        @JsonSchema(description="Is udp enabled? If not, the server will only use TCP")
        private boolean enableUdp;
        @JsonSchema(description="Ship load distance in blocks")
        private double shipLoadDistance = 128.0;
        @JsonSchema(description="Ship unload distance in blocks")
        private double shipUnloadDistance = 196.0;
        @JsonSchema(description="All related settings to the physics engine")
        private PhysicsConfig physics = new PhysicsConfig();

        @JvmName(name="getPt")
        public final PhysicsThreadSettings getPt() {
            return this.pt;
        }

        @JvmName(name="getUdpPort")
        public final int getUdpPort() {
            return this.udpPort;
        }

        @JvmName(name="setUdpPort")
        public final void setUdpPort(int n2) {
            this.udpPort = n2;
        }

        @JvmName(name="getEnableUdp")
        public final boolean getEnableUdp() {
            return this.enableUdp;
        }

        @JvmName(name="setEnableUdp")
        public final void setEnableUdp(boolean bl2) {
            this.enableUdp = bl2;
        }

        @JvmName(name="getShipLoadDistance")
        public final double getShipLoadDistance() {
            return this.shipLoadDistance;
        }

        @JvmName(name="setShipLoadDistance")
        public final void setShipLoadDistance(double d2) {
            this.shipLoadDistance = d2;
        }

        @JvmName(name="getShipUnloadDistance")
        public final double getShipUnloadDistance() {
            return this.shipUnloadDistance;
        }

        @JvmName(name="setShipUnloadDistance")
        public final void setShipUnloadDistance(double d2) {
            this.shipUnloadDistance = d2;
        }

        @JvmName(name="getPhysics")
        public final PhysicsConfig getPhysics() {
            return this.physics;
        }

        @JvmName(name="setPhysics")
        public final void setPhysics(PhysicsConfig physicsConfig) {
            Intrinsics.checkNotNullParameter((Object)physicsConfig, (String)"");
            this.physics = physicsConfig;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0014\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001dR\"\u0010\u0003\u001a\u00020\u00028\u0007@\u0007X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\"\u0010\n\u001a\u00020\t8\u0007@\u0007X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\"\u0010\u0010\u001a\u00020\u00028\u0007@\u0007X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0004\u001a\u0004\b\u0011\u0010\u0006\"\u0004\b\u0012\u0010\bR\"\u0010\u0013\u001a\u00020\u00028\u0007@\u0007X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u0004\u001a\u0004\b\u0014\u0010\u0006\"\u0004\b\u0015\u0010\bR\"\u0010\u0016\u001a\u00020\u00028\u0007@\u0007X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0004\u001a\u0004\b\u0017\u0010\u0006\"\u0004\b\u0018\u0010\bR\"\u0010\u0019\u001a\u00020\u00028\u0007@\u0007X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u0004\u001a\u0004\b\u001a\u0010\u0006\"\u0004\b\u001b\u0010\b"}, d2={"Lorg/valkyrienskies/core/impl/config/VSCoreConfig$Server$PhysicsThreadSettings;", "", "", "physicsTicksPerGameTick", "I", "getPhysicsTicksPerGameTick", "()I", "setPhysicsTicksPerGameTick", "(I)V", "", "synchronizePhysics", "Z", "getSynchronizePhysics", "()Z", "setSynchronizePhysics", "(Z)V", "terrainBakingThreadPriority", "getTerrainBakingThreadPriority", "setTerrainBakingThreadPriority", "terrainBakingThreads", "getTerrainBakingThreads", "setTerrainBakingThreads", "terrainDeletionThreadPriority", "getTerrainDeletionThreadPriority", "setTerrainDeletionThreadPriority", "terrainDeletionThreads", "getTerrainDeletionThreads", "setTerrainDeletionThreads", "<init>", "()V"})
        public static final class PhysicsThreadSettings {
            @JsonSchema(description="Synchronize the physics thread and the game thread")
            private boolean synchronizePhysics;
            private int physicsTicksPerGameTick = 3;
            @JsonSchema(description="Number of terrain baking threads, more is good for preventing stutters when flying fast ships. However, too many will overload the cpu which will lag the game.")
            private int terrainBakingThreads = Runtime.getRuntime().availableProcessors() - 4;
            @JsonSchema(description="Thread priority of terrain baking threads. 5 is default priority, higher is higher priority, lower is lower priority.")
            private int terrainBakingThreadPriority = 5;
            @JsonSchema(description="Number of terrain deletion threads. Typically just 1 is fine.")
            private int terrainDeletionThreads = 1;
            @JsonSchema(description="Thread priority of terrain deletion threads. These are used to clean up memory, so they can be lower priority than.")
            private int terrainDeletionThreadPriority = 4;

            @JvmName(name="getSynchronizePhysics")
            public final boolean getSynchronizePhysics() {
                return this.synchronizePhysics;
            }

            @JvmName(name="setSynchronizePhysics")
            public final void setSynchronizePhysics(boolean bl2) {
                this.synchronizePhysics = bl2;
            }

            @JvmName(name="getPhysicsTicksPerGameTick")
            public final int getPhysicsTicksPerGameTick() {
                return this.physicsTicksPerGameTick;
            }

            @JvmName(name="setPhysicsTicksPerGameTick")
            public final void setPhysicsTicksPerGameTick(int n2) {
                this.physicsTicksPerGameTick = n2;
            }

            @JvmName(name="getTerrainBakingThreads")
            public final int getTerrainBakingThreads() {
                return this.terrainBakingThreads;
            }

            @JvmName(name="setTerrainBakingThreads")
            public final void setTerrainBakingThreads(int n2) {
                this.terrainBakingThreads = n2;
            }

            @JvmName(name="getTerrainBakingThreadPriority")
            public final int getTerrainBakingThreadPriority() {
                return this.terrainBakingThreadPriority;
            }

            @JvmName(name="setTerrainBakingThreadPriority")
            public final void setTerrainBakingThreadPriority(int n2) {
                this.terrainBakingThreadPriority = n2;
            }

            @JvmName(name="getTerrainDeletionThreads")
            public final int getTerrainDeletionThreads() {
                return this.terrainDeletionThreads;
            }

            @JvmName(name="setTerrainDeletionThreads")
            public final void setTerrainDeletionThreads(int n2) {
                this.terrainDeletionThreads = n2;
            }

            @JvmName(name="getTerrainDeletionThreadPriority")
            public final int getTerrainDeletionThreadPriority() {
                return this.terrainDeletionThreadPriority;
            }

            @JvmName(name="setTerrainDeletionThreadPriority")
            public final void setTerrainDeletionThreadPriority(int n2) {
                this.terrainDeletionThreadPriority = n2;
            }
        }
    }

    @bm
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004"}, d2={"Lorg/valkyrienskies/core/impl/config/VSCoreConfig$ServerConfigModule;", "", "Lorg/valkyrienskies/core/impl/config/VSCoreConfig$Server;", "server", "()Lorg/valkyrienskies/core/impl/config/VSCoreConfig$Server;", "<init>", "()V"})
    public static final class ServerConfigModule {
        @bn
        @Singleton
        public final Server server() {
            return SERVER;
        }
    }
}

