/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.mod_compat.create.block;

import com.simibubi.create.content.kinetics.crusher.CrushingWheelBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Vector3d;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Mixin(value={CrushingWheelBlock.class})
public class MixinCrushingWheelBlock {
    @Unique
    private BlockPos blockPosInside;
    @Unique
    private Level levelInside;

    @Inject(method={"entityInside"}, at={@At(value="HEAD")})
    void startInside(BlockState state, Level worldIn, BlockPos pos, Entity entityIn, CallbackInfo info) {
        this.blockPosInside = pos;
        this.levelInside = worldIn;
    }

    @Unique
    void transform(Vector3d in2) {
        Ship ship = VSGameUtilsKt.getShipManagingPos(this.levelInside, this.blockPosInside);
        if (ship != null) {
            ship.getWorldToShip().transformPosition(in2);
        }
    }

    @Redirect(method={"entityInside"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getX()D"))
    double getXPos(Entity entity) {
        Vector3d vector3d = new Vector3d(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        this.transform(vector3d);
        return vector3d.x;
    }

    @Redirect(method={"entityInside"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getY()D"))
    double getYPos(Entity entity) {
        Vector3d vector3d = new Vector3d(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        this.transform(vector3d);
        return vector3d.x;
    }

    @Redirect(method={"entityInside"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getZ()D"))
    double getZPos(Entity entity) {
        Vector3d vector3d = new Vector3d(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        this.transform(vector3d);
        return vector3d.x;
    }
}

