/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.Unit;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.core.api.ships.properties.IShipActiveChunksSet;
import org.valkyrienskies.core.apigame.GameServer;
import org.valkyrienskies.core.apigame.world.ServerShipWorldCore;
import org.valkyrienskies.core.apigame.world.VSPipeline;
import org.valkyrienskies.mod.common.IShipObjectWorldServerProvider;
import org.valkyrienskies.mod.common.ShipSavedData;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.config.MassDatapackResolver;
import org.valkyrienskies.mod.common.hooks.VSGameEvents;
import org.valkyrienskies.mod.common.util.EntityDragger;
import org.valkyrienskies.mod.common.util.VSLevelChunk;
import org.valkyrienskies.mod.common.util.VSServerLevel;
import org.valkyrienskies.mod.common.world.ChunkManagement;
import org.valkyrienskies.mod.util.KrunchSupport;

@Mixin(value={MinecraftServer.class})
public abstract class MixinMinecraftServer
implements IShipObjectWorldServerProvider,
GameServer {
    @Shadow
    private PlayerList f_129763_;
    @Unique
    private ServerShipWorldCore shipWorld;
    @Unique
    private VSPipeline vsPipeline;
    @Unique
    private Set<String> loadedLevels = new HashSet<String>();
    @Unique
    private final Map<String, ServerLevel> dimensionToLevelMap = new HashMap<String, ServerLevel>();

    @Shadow
    public abstract ServerLevel m_129783_();

    @Shadow
    public abstract Iterable<ServerLevel> m_129785_();

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;initServer()Z")}, method={"runServer"})
    private void beforeInitServer(CallbackInfo info) {
        ValkyrienSkiesMod.setCurrentServer((MinecraftServer)MinecraftServer.class.cast(this));
    }

    @Inject(at={@At(value="TAIL")}, method={"stopServer"})
    private void afterStopServer(CallbackInfo ci2) {
        ValkyrienSkiesMod.setCurrentServer(null);
    }

    @Override
    @Nullable
    public ServerShipWorldCore getShipObjectWorld() {
        return this.shipWorld;
    }

    @Override
    @Nullable
    public VSPipeline getVsPipeline() {
        return this.vsPipeline;
    }

    @Inject(method={"createLevels"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;getDataStorage()Lnet/minecraft/world/level/storage/DimensionDataStorage;")})
    private void postCreateLevels(CallbackInfo ci2) {
        ShipSavedData shipSavedData = (ShipSavedData)this.m_129783_().m_8895_().m_164861_(ShipSavedData::load, ShipSavedData.Companion::createEmpty, "vs_ship_data");
        Throwable ex2 = shipSavedData.getLoadingException();
        if (ex2 != null) {
            System.err.println("VALKYRIEN SKIES ERROR WHILE LOADING SHIP DATA");
            ex2.printStackTrace();
            throw new RuntimeException(ex2);
        }
        this.vsPipeline = shipSavedData.getPipeline();
        if (!MassDatapackResolver.INSTANCE.getRegisteredBlocks()) {
            ArrayList blockStateList = new ArrayList(Block.f_49791_.m_13562_());
            Block.f_49791_.forEach(blockStateList::add);
            MassDatapackResolver.INSTANCE.registerAllBlockStates(blockStateList);
        }
        this.vsPipeline.registerBlocks(MassDatapackResolver.INSTANCE.getSolidBlockStates(), MassDatapackResolver.INSTANCE.getLiquidBlockStates(), MassDatapackResolver.INSTANCE.getBlockStateData());
        KrunchSupport.INSTANCE.setKrunchSupported(!this.vsPipeline.isUsingDummyPhysics());
        this.shipWorld = this.vsPipeline.getShipWorld();
        this.shipWorld.setGameServer(this);
        VSGameEvents.INSTANCE.getRegistriesCompleted().emit(Unit.INSTANCE);
        this.getShipObjectWorld().addDimension(VSGameUtilsKt.getDimensionId((Level)this.m_129783_()), VSGameUtilsKt.getYRange((Level)this.m_129783_()));
    }

    @Inject(method={"tickServer"}, at={@At(value="HEAD")})
    private void preTick(CallbackInfo ci2) {
        Set vsPlayers = this.f_129763_.m_11314_().stream().map(VSGameUtilsKt::getPlayerWrapper).collect(Collectors.toSet());
        this.shipWorld.setPlayers(vsPlayers);
        HashMap<String, ServerLevel> newLoadedLevels = new HashMap<String, ServerLevel>();
        for (ServerLevel level : this.m_129785_()) {
            String dimensionId = VSGameUtilsKt.getDimensionId((Level)level);
            newLoadedLevels.put(dimensionId, level);
            this.dimensionToLevelMap.put(dimensionId, level);
        }
        for (String oldLoadedLevelId : this.loadedLevels) {
            if (newLoadedLevels.containsKey(oldLoadedLevelId)) continue;
            this.shipWorld.removeDimension(oldLoadedLevelId);
            this.dimensionToLevelMap.remove(oldLoadedLevelId);
        }
        this.loadedLevels = newLoadedLevels.keySet();
        this.vsPipeline.preTickGame();
    }

    @Inject(method={"tickChildren"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerConnectionListener;tick()V", shift=At.Shift.AFTER)})
    private void preConnectionTick(CallbackInfo ci2) {
        ChunkManagement.tickChunkLoading(this.shipWorld, (MinecraftServer)MinecraftServer.class.cast(this));
    }

    @Shadow
    public abstract ServerLevel m_129880_(ResourceKey<Level> var1);

    @Shadow
    public abstract boolean m_7079_();

    @Inject(method={"tickServer"}, at={@At(value="TAIL")})
    private void postTick(CallbackInfo ci2) {
        this.vsPipeline.postTickGame();
        for (ServerLevel level : this.m_129785_()) {
            EntityDragger.INSTANCE.dragEntitiesWithShips(level.m_8583_());
        }
    }

    @Unique
    private Vec3 getRelativePortalPosition(Direction.Axis axis, BlockUtil.FoundRectangle foundRectangle, EntityDimensions entityDimensions, Vec3 position) {
        return PortalShape.m_77738_((BlockUtil.FoundRectangle)foundRectangle, (Direction.Axis)axis, (Vec3)position, (EntityDimensions)entityDimensions);
    }

    @Unique
    private Optional<BlockUtil.FoundRectangle> getExitPortal(ServerLevel serverLevel, BlockPos blockPos, boolean bl2, WorldBorder worldBorder) {
        return serverLevel.m_8871_().m_192985_(blockPos, bl2, worldBorder);
    }

    @Inject(method={"stopServer"}, at={@At(value="HEAD")})
    private void preStopServer(CallbackInfo ci2) {
        if (this.vsPipeline != null) {
            this.vsPipeline.setDeleteResources(true);
            this.vsPipeline.setArePhysicsRunning(true);
        }
        this.dimensionToLevelMap.clear();
        this.shipWorld.setGameServer(null);
        this.shipWorld = null;
    }

    @NotNull
    private ServerLevel getLevelFromDimensionId(@NotNull String dimensionId) {
        return this.dimensionToLevelMap.get(dimensionId);
    }

    @Override
    public void moveTerrainAcrossDimensions(@NotNull IShipActiveChunksSet shipChunks, @NotNull String srcDimension, @NotNull String destDimension) {
        ServerLevel srcLevel = this.getLevelFromDimensionId(srcDimension);
        ServerLevel destLevel = this.getLevelFromDimensionId(destDimension);
        shipChunks.forEach((x2, z2) -> {
            LevelChunk srcChunk = srcLevel.m_6325_(x2, z2);
            ((VSServerLevel)destLevel).removeChunk(x2, z2);
            LevelChunk destChunk = destLevel.m_6325_(x2, z2);
            ((VSLevelChunk)destChunk).copyChunkFromOtherDimension((VSLevelChunk)srcChunk);
        });
        shipChunks.forEach((x2, z2) -> {
            LevelChunk srcChunk = srcLevel.m_6325_(x2, z2);
            ((VSLevelChunk)srcChunk).clearChunk();
            ChunkPos chunkPos = srcChunk.m_7697_();
            srcLevel.m_7726_().m_6692_(chunkPos, false);
            ((VSServerLevel)srcLevel).removeChunk(x2, z2);
        });
    }
}

