/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.villagesandpillages.world.processor;

import com.faboslav.villagesandpillages.init.VillagesAndPillagesProcessorTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public final class CollapsedUnderwaterProcessor
extends StructureProcessor {
    public static final Codec<CollapsedUnderwaterProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.f_61039_.fieldOf("target_block").forGetter(config -> config.targetBlock), (App)BlockState.f_61039_.fieldOf("target_block_output").forGetter(config -> config.targetBlockOutput), (App)Direction.f_175356_.optionalFieldOf("direction", (Object)Direction.DOWN).forGetter(processor -> processor.direction), (App)Codec.INT.optionalFieldOf("pillar_length", (Object)-1).forGetter(config -> config.length)).apply((Applicative)instance, instance.stable(CollapsedUnderwaterProcessor::new)));
    public final BlockState targetBlock;
    public final BlockState targetBlockOutput;
    public final Direction direction;
    public final int length;

    private CollapsedUnderwaterProcessor(BlockState targetBlock, BlockState targetBlockOutput, Direction direction, int length) {
        this.targetBlock = targetBlock;
        this.targetBlockOutput = targetBlockOutput;
        this.direction = direction;
        this.length = length;
    }

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader worldView, BlockPos pos, BlockPos pivot, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData) {
        if (blockInfoGlobal.f_74676_().m_60713_(this.targetBlock.m_60734_())) {
            WorldGenRegion chunkRegion;
            if (worldView instanceof WorldGenRegion && !(chunkRegion = (WorldGenRegion)worldView).m_143488_().equals((Object)new ChunkPos(blockInfoGlobal.f_74675_()))) {
                return blockInfoGlobal;
            }
            blockInfoGlobal = new StructureTemplate.StructureBlockInfo(blockInfoGlobal.f_74675_(), Blocks.f_50016_.m_49966_(), blockInfoGlobal.f_74677_());
            BlockPos.MutableBlockPos mutable = blockInfoGlobal.f_74675_().m_122032_().m_122173_(Direction.DOWN);
            BlockState currentBlockState = worldView.m_8055_((BlockPos)mutable);
            RandomSource random = structurePlacementData.m_230326_(blockInfoGlobal.f_74675_());
            while (mutable.m_123342_() > worldView.m_141937_() && mutable.m_123342_() < worldView.m_151558_() && (currentBlockState.m_60795_() || !worldView.m_6425_((BlockPos)mutable).m_76178_())) {
                if (!currentBlockState.m_60795_() && !worldView.m_6425_((BlockPos)mutable).m_76178_() && worldView.m_6425_(mutable.m_122032_().m_7495_()).m_76178_() && random.m_216332_(0, 5) > 1) {
                    BlockState modifiedTargetBlockOutput = this.targetBlockOutput;
                    if (modifiedTargetBlockOutput.m_61138_((Property)BlockStateProperties.f_61362_)) {
                        modifiedTargetBlockOutput = (BlockState)this.targetBlockOutput.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
                    }
                    worldView.m_46865_((BlockPos)mutable).m_6978_((BlockPos)mutable, modifiedTargetBlockOutput, false);
                    break;
                }
                mutable.m_122173_(Direction.DOWN);
                currentBlockState = worldView.m_8055_((BlockPos)mutable);
            }
        }
        return blockInfoGlobal;
    }

    protected StructureProcessorType<?> m_6953_() {
        return VillagesAndPillagesProcessorTypes.COLLAPSED_UNDERWATER_PROCESSOR;
    }
}

