/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.network.chat.Component;

public final class BossBarsRenderManager {
    public static Function<Minecraft, Integer> DEFAULT_INCREMENT = minecraft -> {
        Objects.requireNonNull(minecraft.f_91062_);
        return 10 + 9;
    };
    private static final List<Style> REGISTRY = new ArrayList<Style>();
    private static final List<Supplier<List<Style>>> REGISTRIES;

    public static void register(String key, boolean literal, boolean renderBar, boolean renderName, Function<Minecraft, Integer> increment, BossBarRenderer function) {
        Style style = new Style(key, literal, renderBar, renderName, increment, function);
        REGISTRY.add(style);
    }

    public static void register(List<Style> registry, String key, boolean literal, boolean renderBar, boolean renderName, Function<Minecraft, Integer> increment, BossBarRenderer function) {
        if (registry == null) {
            return;
        }
        Style style = new Style(key, literal, renderBar, renderName, increment, function);
        registry.add(style);
    }

    public static void addRegistry(Supplier<List<Style>> holder) {
        REGISTRIES.add(holder);
    }

    public static Optional<Style> getStyle(Component bossBar) {
        for (Style style : BossBarsRenderManager.getStyles()) {
            if (!style.equals(bossBar)) continue;
            return Optional.of(style);
        }
        return Optional.empty();
    }

    @Nonnull
    public static List<Style> getStyles() {
        ArrayList<Style> styles = new ArrayList<Style>();
        for (Supplier<List<Style>> list : REGISTRIES) {
            styles.addAll((Collection<Style>)list.get());
        }
        return styles;
    }

    static {
        ArrayList<Supplier<List<Style>>> list = new ArrayList<Supplier<List<Style>>>();
        list.add(() -> REGISTRY);
        REGISTRIES = list;
    }

    public static class Style {
        private final String KEY;
        private final boolean LITERAL_KEY;
        private final BossBarRenderer FUNCTION;
        private final Function<Minecraft, Integer> INCREMENT;
        private final boolean RENDER_BAR;
        private final boolean RENDER_NAME;

        private Style(String key, boolean literal, boolean renderBar, boolean renderName, Function<Minecraft, Integer> increment, BossBarRenderer function) {
            this.KEY = key;
            this.LITERAL_KEY = literal;
            this.FUNCTION = function;
            this.INCREMENT = increment;
            this.RENDER_BAR = renderBar;
            this.RENDER_NAME = renderName;
        }

        public boolean equals(@Nonnull Component name) {
            return name.getString().equals(this.LITERAL_KEY ? this.KEY : Component.m_237115_((String)this.KEY).getString());
        }

        public BossBarRenderer getFunction() {
            return this.FUNCTION;
        }

        public int getIncrement(Minecraft minecraft) {
            return this.INCREMENT.apply(minecraft);
        }

        public boolean shouldRenderBar() {
            return this.RENDER_BAR;
        }

        public boolean shouldRenderName() {
            return this.RENDER_NAME;
        }
    }

    @FunctionalInterface
    public static interface BossBarRenderer {
        public void render(Minecraft var1, GuiGraphics var2, int var3, int var4, LerpingBossEvent var5, Component var6);
    }
}

