/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.api.hekate;

import com.obscuria.obscureapi.api.hekate.Interpolation;

public final class Interpolations {
    public static final Interpolation CEIL = progress -> 1.0f;
    public static final Interpolation FLOOR = progress -> 0.0f;
    public static final Interpolation LINEAR = progress -> progress;
    public static final Interpolation EASE_OUT_SINE = progress -> (float)Math.sin((double)progress * Math.PI / 2.0);
    public static final Interpolation EASE_OUT_CIRCLE = progress -> (float)Math.sqrt(1.0 - Math.pow(progress - 1.0f, 2.0));
    public static final Interpolation EASE_OUT_QUAD = progress -> 1.0f - (float)Math.pow(progress - 1.0f, 2.0);
    public static final Interpolation EASE_OUT_CUBIC = progress -> 1.0f + (float)Math.pow(progress - 1.0f, 3.0);
    public static final Interpolation EASE_OUT_QUART = progress -> 1.0f - (float)Math.pow(progress - 1.0f, 4.0);
    public static final Interpolation EASE_OUT_QUINT = progress -> 1.0f + (float)Math.pow(progress - 1.0f, 5.0);
    public static final Interpolation EASE_OUT_EXPO = progress -> progress == 1.0f ? 1.0f : 1.0f - (float)Math.pow(2.0, -10.0f * progress);
    public static final Interpolation EASE_OUT_BACK = progress -> 1.0f + 2.70158f * (float)Math.pow(progress - 1.0f, 3.0) + 1.70158f * (float)Math.pow(progress - 1.0f, 2.0);
    public static final Interpolation EASE_OUT_ELASTIC = progress -> progress == 0.0f ? 0.0f : (progress == 1.0f ? 1.0f : (float)(Math.pow(2.0, -10.0f * progress) * Math.sin((double)(progress * 10.0f - 0.75f) * 2.0943951023931953) + 1.0));
    public static final Interpolation EASE_OUT_BOUNCE = progress -> {
        float f1 = 7.5625f;
        float f2 = 2.75f;
        if (progress < 1.0f / f2) {
            return f1 * progress * progress;
        }
        if (progress < 2.0f / f2) {
            return f1 * (progress -= 1.5f / f2) * progress + 0.75f;
        }
        if ((double)progress < 2.5 / (double)f2) {
            return f1 * (progress -= 2.25f / f2) * progress + 0.9375f;
        }
        return f1 * (progress -= 2.625f / f2) * progress + 0.984375f;
    };
    public static final Interpolation EASE_IN_SINE = progress -> 1.0f - (float)Math.cos((double)progress * Math.PI / 2.0);
    public static final Interpolation EASE_IN_CIRCLE = progress -> 1.0f - (float)Math.sqrt(1.0 - Math.pow(progress, 2.0));
    public static final Interpolation EASE_IN_QUAD = progress -> (float)Math.pow(progress, 2.0);
    public static final Interpolation EASE_IN_CUBIC = progress -> (float)Math.pow(progress, 3.0);
    public static final Interpolation EASE_IN_QUART = progress -> (float)Math.pow(progress, 4.0);
    public static final Interpolation EASE_IN_QUINT = progress -> (float)Math.pow(progress, 5.0);
    public static final Interpolation EASE_IN_EXPO = progress -> progress == 0.0f ? 0.0f : (float)Math.pow(2.0, 10.0f * progress - 10.0f);
    public static final Interpolation EASE_IN_BACK = progress -> 2.70158f * progress * progress * progress - 1.70158f * progress * progress;
    public static final Interpolation EASE_IN_ELASTIC = progress -> progress == 0.0f ? 0.0f : (progress == 1.0f ? 1.0f : (float)(-Math.pow(2.0, 10.0f * progress - 10.0f) * Math.sin((double)(progress * 10.0f - 10.75f) * 2.0943951023931953)));
    public static final Interpolation EASE_IN_BOUNCE = progress -> 1.0f - EASE_OUT_BOUNCE.get(1.0f - progress);
    public static final Interpolation EASE_IN_OUT_SINE = EASE_IN_SINE.with(EASE_OUT_SINE);
    public static final Interpolation EASE_IN_OUT_CIRCLE = EASE_IN_CIRCLE.with(EASE_OUT_CIRCLE);
    public static final Interpolation EASE_IN_OUT_QUAD = EASE_IN_QUAD.with(EASE_OUT_QUAD);
    public static final Interpolation EASE_IN_OUT_CUBIC = EASE_IN_CUBIC.with(EASE_OUT_CUBIC);
    public static final Interpolation EASE_IN_OUT_QUART = EASE_IN_QUART.with(EASE_OUT_QUART);
    public static final Interpolation EASE_IN_OUT_QUINT = EASE_IN_QUINT.with(EASE_OUT_QUINT);
    public static final Interpolation EASE_IN_OUT_BACK;
    public static final Interpolation EASE_IN_OUT_ELASTIC;
    public static final Interpolation EASE_IN_OUT_BOUNCE;
    public static final Interpolation EASE_IN_OUT_EXPO;
    public static final Interpolation EASE_OUT_IN_SINE;
    public static final Interpolation EASE_OUT_IN_CIRCLE;
    public static final Interpolation EASE_OUT_IN_QUAD;
    public static final Interpolation EASE_OUT_IN_CUBIC;
    public static final Interpolation EASE_OUT_IN_QUART;
    public static final Interpolation EASE_OUT_IN_QUINT;
    public static final Interpolation EASE_OUT_IN_BACK;
    public static final Interpolation EASE_OUT_IN_ELASTIC;
    public static final Interpolation EASE_OUT_IN_BOUNCE;
    public static final Interpolation EASE_OUT_IN_EXPO;

    public static void init() {
    }

    static {
        EASE_IN_OUT_EXPO = EASE_IN_EXPO.with(EASE_OUT_EXPO);
        EASE_IN_OUT_BACK = EASE_IN_BACK.with(EASE_OUT_BACK);
        EASE_IN_OUT_ELASTIC = EASE_IN_ELASTIC.with(EASE_OUT_ELASTIC);
        EASE_IN_OUT_BOUNCE = EASE_IN_BOUNCE.with(EASE_OUT_BOUNCE);
        EASE_OUT_IN_SINE = EASE_OUT_SINE.with(EASE_IN_SINE);
        EASE_OUT_IN_CIRCLE = EASE_OUT_CIRCLE.with(EASE_IN_CIRCLE);
        EASE_OUT_IN_QUAD = EASE_OUT_QUAD.with(EASE_IN_QUAD);
        EASE_OUT_IN_CUBIC = EASE_OUT_CUBIC.with(EASE_IN_CUBIC);
        EASE_OUT_IN_QUART = EASE_OUT_QUART.with(EASE_IN_QUART);
        EASE_OUT_IN_QUINT = EASE_OUT_QUINT.with(EASE_IN_QUINT);
        EASE_OUT_IN_EXPO = EASE_OUT_EXPO.with(EASE_IN_EXPO);
        EASE_OUT_IN_BACK = EASE_OUT_BACK.with(EASE_IN_BACK);
        EASE_OUT_IN_ELASTIC = EASE_OUT_ELASTIC.with(EASE_IN_ELASTIC);
        EASE_OUT_IN_BOUNCE = EASE_OUT_BOUNCE.with(EASE_IN_BOUNCE);
    }
}

