/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.registry;

import com.obscuria.obscureapi.api.utils.ExceptionFilter;
import com.obscuria.obscureapi.event.ObscureAPIHooks;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class ObscureAPIAttributes {
    public static final DeferredRegister<Attribute> REGISTRY = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.ATTRIBUTES, (String)"obscure_api");
    public static final RegistryObject<Attribute> CRITICAL_HIT = REGISTRY.register("critical_hit", () -> new RangedAttribute("obscure_api.criticalHit", 0.0, 0.0, 100.0).m_22084_(true));
    public static final RegistryObject<Attribute> CRITICAL_DAMAGE = REGISTRY.register("critical_damage", () -> new RangedAttribute("obscure_api.criticalDamage", 2.0, 0.0, 100.0).m_22084_(true));
    public static final RegistryObject<Attribute> DODGE = REGISTRY.register("dodge", () -> new RangedAttribute("obscure_api.dodge", 0.0, 0.0, 100.0).m_22084_(true));
    public static final RegistryObject<Attribute> PARRY = REGISTRY.register("parry", () -> new RangedAttribute("obscure_api.parry", 0.0, 0.0, 100.0).m_22084_(true));
    public static final RegistryObject<Attribute> MAGIC_DAMAGE = REGISTRY.register("magic_damage", () -> new RangedAttribute("obscure_api.magicDamage", 0.0, 0.0, 100000.0).m_22084_(true));
    public static final RegistryObject<Attribute> MAGIC_RESISTANCE = REGISTRY.register("magic_resistance", () -> new RangedAttribute("obscure_api.magicResistance", 0.0, 0.0, 100.0).m_22084_(true));
    public static final RegistryObject<Attribute> PENETRATION = REGISTRY.register("penetration", () -> new RangedAttribute("obscure_api.penetration", 0.0, 0.0, 100.0).m_22084_(true));
    public static final RegistryObject<Attribute> REGENERATION = REGISTRY.register("regeneration", () -> new RangedAttribute("obscure_api.regeneration", 0.0, 0.0, 100000.0).m_22084_(true));
    public static final RegistryObject<Attribute> HEALING_POWER = REGISTRY.register("healing_power", () -> new RangedAttribute("obscure_api.healingPower", 1.0, 0.0, 100.0).m_22084_(true));
    public static final RegistryObject<Attribute> ACCURACY = REGISTRY.register("accuracy", () -> new RangedAttribute("obscure_api.accuracy", 0.0, 0.0, 100.0).m_22084_(true));
    public static final RegistryObject<Attribute> RESILIENCE = REGISTRY.register("resilience", () -> new RangedAttribute("obscure_api.resilience", 0.0, 0.0, 100.0).m_22084_(true));

    public static float getCriticalHit(LivingEntity entity) {
        return ExceptionFilter.getNoNull(Float.valueOf(0.0f), () -> Float.valueOf(ObscureAPIAttributes.getPercent(entity, (Attribute)CRITICAL_HIT.get(), 0.0f, 0.0f, 1.0f))).floatValue();
    }

    public static float getCriticalDamage(LivingEntity entity) {
        return ExceptionFilter.getNoNull(Float.valueOf(2.0f), () -> Float.valueOf(ObscureAPIAttributes.getPercent(entity, (Attribute)CRITICAL_DAMAGE.get(), 0.0f, 0.0f, 10.0f))).floatValue();
    }

    public static float getDodge(LivingEntity entity) {
        return ExceptionFilter.getNoNull(Float.valueOf(0.0f), () -> Float.valueOf(ObscureAPIAttributes.getPercent(entity, (Attribute)DODGE.get(), 0.0f, 0.0f, 0.8f))).floatValue();
    }

    public static float getParry(LivingEntity entity) {
        return ExceptionFilter.getNoNull(Float.valueOf(0.0f), () -> Float.valueOf(ObscureAPIAttributes.getPercent(entity, (Attribute)PARRY.get(), 0.0f, 0.0f, 0.8f))).floatValue();
    }

    public static float getMagicDamage(LivingEntity entity) {
        return ExceptionFilter.getNoNull(Float.valueOf(0.0f), () -> Float.valueOf(ObscureAPIAttributes.getValue(entity, (Attribute)MAGIC_DAMAGE.get(), 0.0f, 0.0f, 999999.0f))).floatValue();
    }

    public static float getMagicResistance(LivingEntity entity) {
        return ExceptionFilter.getNoNull(Float.valueOf(0.0f), () -> Float.valueOf(ObscureAPIAttributes.getPercent(entity, (Attribute)MAGIC_RESISTANCE.get(), 0.0f, 0.0f, 0.8f))).floatValue();
    }

    public static float getPenetration(LivingEntity entity) {
        return ExceptionFilter.getNoNull(Float.valueOf(0.0f), () -> Float.valueOf(ObscureAPIAttributes.getPercent(entity, (Attribute)PENETRATION.get(), 0.0f, 0.0f, 1.0f))).floatValue();
    }

    public static float getAccuracy(LivingEntity entity) {
        return ExceptionFilter.getNoNull(Float.valueOf(0.0f), () -> Float.valueOf(ObscureAPIAttributes.getPercent(entity, (Attribute)ACCURACY.get(), 0.0f, 0.0f, 1.0f))).floatValue();
    }

    public static float getRegeneration(LivingEntity entity) {
        return ExceptionFilter.getNoNull(Float.valueOf(0.0f), () -> Float.valueOf(ObscureAPIAttributes.getValue(entity, (Attribute)REGENERATION.get(), 0.0f, 0.0f, 99.0f))).floatValue();
    }

    public static float getHealingPower(LivingEntity entity) {
        return ExceptionFilter.getNoNull(Float.valueOf(1.0f), () -> Float.valueOf(ObscureAPIAttributes.getPercent(entity, (Attribute)HEALING_POWER.get(), 0.0f, 0.0f, 10.0f))).floatValue();
    }

    public static float getResilience(LivingEntity entity) {
        return ExceptionFilter.getNoNull(Float.valueOf(0.0f), () -> Float.valueOf(ObscureAPIAttributes.getPercent(entity, (Attribute)RESILIENCE.get(), 0.0f, 0.0f, 0.5f))).floatValue();
    }

    private static float getPercent(LivingEntity entity, Attribute attr, float base, float min, float max) {
        AttributeInstance attributeInstance = entity.m_21051_(attr);
        double amount = entity.m_21172_(attr);
        if (attributeInstance != null) {
            for (AttributeModifier attribute : attributeInstance.m_22104_(AttributeModifier.Operation.ADDITION)) {
                amount += attribute.m_22218_();
            }
            for (AttributeModifier attribute : attributeInstance.m_22104_(AttributeModifier.Operation.MULTIPLY_BASE)) {
                amount += attribute.m_22218_();
            }
            for (AttributeModifier attribute : attributeInstance.m_22104_(AttributeModifier.Operation.MULTIPLY_TOTAL)) {
                amount += attribute.m_22218_();
            }
        }
        return Math.max(min, Math.min(max, base + (float)amount));
    }

    private static float getValue(LivingEntity entity, Attribute attr, float base, float min, float max) {
        AttributeInstance attributeInstance = entity.m_21051_(attr);
        double baseAmount = entity.m_21172_(attr);
        double amount = 0.0;
        double modBase = 1.0;
        double modTotal = 1.0;
        if (attributeInstance != null) {
            for (AttributeModifier attribute : attributeInstance.m_22104_(AttributeModifier.Operation.ADDITION)) {
                amount += attribute.m_22218_();
            }
            for (AttributeModifier attribute : attributeInstance.m_22104_(AttributeModifier.Operation.MULTIPLY_BASE)) {
                modBase += attribute.m_22218_();
            }
            for (AttributeModifier attribute : attributeInstance.m_22104_(AttributeModifier.Operation.MULTIPLY_TOTAL)) {
                modTotal += attribute.m_22218_();
            }
        }
        return Math.max(min, Math.min(max, base + (float)((baseAmount * modBase + amount) * modTotal)));
    }

    public static void regenerationEvent(@NotNull LivingEvent.LivingTickEvent event) {
        float heal;
        if (event.getEntity() == null || event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (event.getEntity().f_19797_ % 400 == 0 && (heal = ObscureAPIHooks.onRegeneration(event.getEntity(), ObscureAPIAttributes.getRegeneration(event.getEntity()))) > 0.0f) {
            event.getEntity().m_5634_(heal);
        }
    }

    public static void healEvent(@NotNull LivingHealEvent event) {
        if (event.getEntity() != null) {
            event.setAmount(event.getAmount() * ObscureAPIAttributes.getHealingPower(event.getEntity()));
        }
    }

    public static void parryAndDodgeEvent(@NotNull LivingAttackEvent event) {
        LivingEntity living;
        LivingEntity source;
        LivingEntity target = event.getEntity();
        Entity entity = event.getSource().m_7639_();
        LivingEntity livingEntity = source = entity instanceof LivingEntity ? (living = (LivingEntity)entity) : null;
        if (target == null || source == null || target.f_19802_ > 10) {
            return;
        }
        float accuracy = ObscureAPIAttributes.getAccuracy(source);
        float parry = ObscureAPIAttributes.getParry(target);
        if (Math.random() <= (double)(parry - accuracy) && ObscureAPIHooks.onParry(target, source, parry - accuracy)) {
            event.setCanceled(true);
            target.f_19802_ = 20;
            source.m_6469_(source.m_269291_().m_269333_(target), event.getAmount());
            return;
        }
        float dodge = ObscureAPIAttributes.getDodge(target);
        if (Math.random() <= (double)(dodge - accuracy) && ObscureAPIHooks.onDodge(target, source, dodge - accuracy)) {
            event.setCanceled(true);
            target.f_19802_ = 20;
        }
    }

    public static void criticalHitAndMagicResistanceEvent(@NotNull LivingHurtEvent event) {
        LivingEntity living;
        LivingEntity entity = event.getEntity();
        Entity entity2 = event.getSource().m_7639_();
        LivingEntity source = entity2 instanceof LivingEntity ? (living = (LivingEntity)entity2) : null;
        float amount = event.getAmount();
        if (entity == null || source == null) {
            return;
        }
        if (event.getSource() != source.m_269291_().m_269425_()) {
            double criticalHit = ObscureAPIAttributes.getCriticalHit(source);
            double criticalDamage = ObscureAPIAttributes.getCriticalDamage(source);
            double resilience = ObscureAPIAttributes.getResilience(entity);
            if (Math.random() <= criticalHit - resilience) {
                float criticalAmount = amount * (float)criticalDamage * (float)(1.0 - resilience);
                float finalAmount = ObscureAPIHooks.onCriticalHit(entity, source, event.getSource(), criticalAmount);
                if (finalAmount > 0.0f) {
                    event.setAmount(finalAmount);
                }
            }
        }
        if (event.getSource() == source.m_269291_().m_269425_()) {
            event.setAmount(amount * (1.0f - ObscureAPIAttributes.getMagicResistance(entity)));
        }
    }

    public static void magicDamageEvent(@NotNull LivingDamageEvent event) {
        double magicDamage;
        LivingEntity living;
        LivingEntity source;
        LivingEntity entity = event.getEntity();
        Entity entity2 = event.getSource().m_7639_();
        LivingEntity livingEntity = source = entity2 instanceof LivingEntity ? (living = (LivingEntity)entity2) : null;
        if (entity == null || source == null) {
            return;
        }
        if (!entity.m_6673_(source.m_269291_().m_269425_()) && (magicDamage = (double)(ObscureAPIAttributes.getMagicDamage(source) * (1.0f - ObscureAPIAttributes.getMagicResistance(entity)))) > 0.0) {
            event.setAmount(event.getAmount() + (float)magicDamage);
        }
    }
}

