/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.config.core;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.core.file.FileWatcher;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.mojang.logging.LogUtils;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.impl.PuzzlesLib;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Function;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.config.ConfigFileTypeHandler;
import net.minecraftforge.fml.config.IConfigEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLConfig;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class ForgeConfigFileTypeHandler
extends ConfigFileTypeHandler {
    static final Marker CONFIG = MarkerFactory.getMarker((String)"CONFIG");
    private static final Logger LOGGER = LogUtils.getLogger();
    static final ConfigFileTypeHandler TOML = new ForgeConfigFileTypeHandler();
    private static final Path DEFAULT_CONFIGS_PATH = ModLoaderEnvironment.INSTANCE.getGameDirectory().resolve(FMLConfig.defaultConfigPath());

    private static void tryLoadConfigFile(FileConfig configData) {
        try {
            configData.load();
        }
        catch (ParsingException e) {
            try {
                Files.delete(configData.getNioPath());
                configData.load();
                PuzzlesLib.LOGGER.warn("Configuration file {} could not be parsed. Correcting", (Object)configData.getNioPath());
                return;
            }
            catch (Throwable t) {
                e.addSuppressed(t);
                throw e;
            }
        }
    }

    public Function<ModConfig, CommentedFileConfig> reader(Path configBasePath) {
        return c -> {
            Path configPath = ModLoaderEnvironment.INSTANCE.getConfigDirectory().resolve(c.getFileName());
            CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)configPath).sync().preserveInsertionOrder().autosave().onFileNotFound((newfile, configFormat) -> this.setupConfigFile((ModConfig)c, newfile, (ConfigFormat<?>)configFormat)).writingMode(WritingMode.REPLACE).build();
            LOGGER.debug(CONFIG, "Built TOML config for {}", (Object)configPath);
            try {
                ForgeConfigFileTypeHandler.tryLoadConfigFile((FileConfig)configData);
            }
            catch (ParsingException ex) {
                throw new ConfigLoadingException((ModConfig)c, (Exception)((Object)ex));
            }
            LOGGER.debug(CONFIG, "Loaded TOML config file {}", (Object)configPath);
            try {
                FileWatcher.defaultInstance().addWatch(configPath, (Runnable)new ConfigWatcher((ModConfig)c, configData, Thread.currentThread().getContextClassLoader()));
                LOGGER.debug(CONFIG, "Watching TOML config file {} for changes", (Object)configPath);
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't watch config file", e);
            }
            return configData;
        };
    }

    public void unload(Path configBasePath, ModConfig config) {
        Path configPath = ModLoaderEnvironment.INSTANCE.getConfigDirectory().resolve(config.getFileName());
        try {
            FileWatcher.defaultInstance().removeWatch(configPath);
        }
        catch (RuntimeException e) {
            LOGGER.error("Failed to remove config {} from tracker!", (Object)configPath, (Object)e);
        }
    }

    private boolean setupConfigFile(ModConfig modConfig, Path file, ConfigFormat<?> conf) throws IOException {
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        Path p = DEFAULT_CONFIGS_PATH.resolve(modConfig.getFileName());
        if (Files.exists(p, new LinkOption[0])) {
            LOGGER.info(CONFIG, "Loading default config file from path {}", (Object)p);
            Files.copy(p, file, new CopyOption[0]);
        } else {
            Files.createFile(file, new FileAttribute[0]);
            conf.initEmptyFile(file);
        }
        return true;
    }

    private static class ConfigLoadingException
    extends RuntimeException {
        public ConfigLoadingException(ModConfig config, Exception cause) {
            super("Failed loading config file " + config.getFileName() + " of type " + config.getType() + " for modid " + config.getModId(), cause);
        }
    }

    private static class ConfigWatcher
    implements Runnable {
        private final ModConfig modConfig;
        private final CommentedFileConfig commentedFileConfig;
        private final ClassLoader realClassLoader;
        private final ModContainer modContainer;

        ConfigWatcher(ModConfig modConfig, CommentedFileConfig commentedFileConfig, ClassLoader classLoader) {
            this.modConfig = modConfig;
            this.commentedFileConfig = commentedFileConfig;
            this.realClassLoader = classLoader;
            this.modContainer = (ModContainer)ModList.get().getModContainerById(modConfig.getModId()).orElseThrow();
        }

        @Override
        public void run() {
            Thread.currentThread().setContextClassLoader(this.realClassLoader);
            if (!this.modConfig.getSpec().isCorrecting()) {
                try {
                    ForgeConfigFileTypeHandler.tryLoadConfigFile((FileConfig)this.commentedFileConfig);
                    if (!this.modConfig.getSpec().isCorrect((CommentedConfig)this.commentedFileConfig)) {
                        LOGGER.warn(CONFIG, "Configuration file {} is not correct. Correcting", (Object)this.commentedFileConfig.getFile().getAbsolutePath());
                        ConfigFileTypeHandler.backUpConfig((CommentedFileConfig)this.commentedFileConfig);
                        this.modConfig.getSpec().correct((CommentedConfig)this.commentedFileConfig);
                        this.commentedFileConfig.save();
                    }
                }
                catch (ParsingException ex) {
                    throw new ConfigLoadingException(this.modConfig, (Exception)((Object)ex));
                }
                LOGGER.debug(CONFIG, "Config file {} changed, sending notifies", (Object)this.modConfig.getFileName());
                this.modConfig.getSpec().afterReload();
                this.modContainer.dispatchConfigEvent(IConfigEvent.reloading((ModConfig)this.modConfig));
            }
        }
    }
}

