/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.config.gui;

import com.seibel.distanthorizons.api.enums.config.EDhApiGpuUploadMethod;
import com.seibel.distanthorizons.core.config.gui.AbstractScreen;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.render.glObject.buffer.GLVertexBuffer;
import com.seibel.distanthorizons.core.render.glObject.shader.ShaderProgram;
import com.seibel.distanthorizons.core.render.glObject.vertexAttribute.AbstractVertexAttribute;
import com.seibel.distanthorizons.core.render.glObject.vertexAttribute.VertexPointer;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftGLWrapper;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.lwjgl.opengl.GL32;

public class OpenGLConfigScreen
extends AbstractScreen {
    private static final IMinecraftGLWrapper GLMC = SingletonInjector.INSTANCE.get(IMinecraftGLWrapper.class);
    private ShaderProgram basicShader;
    private GLVertexBuffer sameContextBuffer;
    private GLVertexBuffer sharedContextBuffer;
    private AbstractVertexAttribute va;
    private static final float[] vertices = new float[]{-0.5f, -0.5f, 0.0f, 0.0f, 0.0f, 1.0f, 0.4f, -0.4f, 1.0f, 0.0f, 0.0f, 1.0f, 0.3f, 0.3f, 1.0f, 1.0f, 0.0f, 0.0f, -0.2f, 0.2f, 0.0f, 1.0f, 1.0f, 1.0f};

    @Override
    public void init() {
        System.out.println("init");
        this.va = AbstractVertexAttribute.create();
        this.va.bind();
        this.va.setVertexAttribute(0, 0, VertexPointer.addVec2Pointer(false));
        this.va.setVertexAttribute(0, 1, VertexPointer.addVec4Pointer(false));
        this.va.completeAndCheck(24);
        this.basicShader = new ShaderProgram("shaders/test/vert.vert", "shaders/test/frag.frag", "fragColor", new String[]{"vPosition", "color"});
        this.createBuffer();
    }

    private static GLVertexBuffer createTextingBuffer() {
        ByteBuffer buffer = ByteBuffer.allocateDirect(vertices.length * 4);
        buffer = buffer.order(ByteOrder.nativeOrder());
        buffer.asFloatBuffer().put(vertices);
        buffer.rewind();
        GLVertexBuffer vbo = new GLVertexBuffer(false);
        vbo.bind();
        vbo.uploadBuffer(buffer, 4, EDhApiGpuUploadMethod.DATA, vertices.length * 4);
        return vbo;
    }

    private void createBuffer() {
        this.sharedContextBuffer = OpenGLConfigScreen.createTextingBuffer();
        this.sameContextBuffer = OpenGLConfigScreen.createTextingBuffer();
    }

    @Override
    public void render(float delta) {
        System.out.println("Updated config screen with the delta of " + delta);
        GL32.glViewport((int)0, (int)0, (int)this.width, (int)this.height);
        GL32.glPolygonMode((int)1032, (int)6914);
        GLMC.disableFaceCulling();
        GLMC.disableDepthTest();
        GLMC.disableBlend();
        this.basicShader.bind();
        this.va.bind();
        if (System.currentTimeMillis() % 2000L < 1000L) {
            this.sameContextBuffer.bind();
            this.va.bindBufferToAllBindingPoints(this.sameContextBuffer.getId());
        } else {
            this.sameContextBuffer.bind();
            this.va.bindBufferToAllBindingPoints(this.sharedContextBuffer.getId());
        }
        GL32.glDrawArrays((int)6, (int)0, (int)4);
        GL32.glClear((int)256);
    }

    @Override
    public void tick() {
        System.out.println("Ticked");
    }
}

