/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util.math;

import com.seibel.distanthorizons.api.objects.math.DhApiVec3f;
import com.seibel.distanthorizons.core.util.math.Vec3d;
import com.seibel.distanthorizons.coreapi.util.MathUtil;

public class Vec3f
extends DhApiVec3f {
    public Vec3f() {
        this(0.0f, 0.0f, 0.0f);
    }

    public Vec3f(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vec3f(DhApiVec3f pos) {
        this.x = pos.x;
        this.y = pos.y;
        this.z = pos.z;
    }

    public Vec3f(Vec3d pos) {
        this.x = (float)pos.x;
        this.y = (float)pos.y;
        this.z = (float)pos.z;
    }

    public void mul(float scalar) {
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
    }

    public void mul(float x, float y, float z) {
        this.x *= x;
        this.y *= y;
        this.z *= z;
    }

    public void clamp(float min, float max) {
        this.x = MathUtil.clamp(min, this.x, max);
        this.y = MathUtil.clamp(min, this.y, max);
        this.z = MathUtil.clamp(min, this.z, max);
    }

    public void add(float x, float y, float z) {
        this.x += x;
        this.y += y;
        this.z += z;
    }

    public void add(Vec3f vector) {
        this.x += vector.x;
        this.y += vector.y;
        this.z += vector.z;
    }

    public void subtract(Vec3f vector) {
        this.x -= vector.x;
        this.y -= vector.y;
        this.z -= vector.z;
    }

    public float dotProduct(Vec3f vector) {
        return this.x * vector.x + this.y * vector.y + this.z * vector.z;
    }

    public boolean normalize() {
        float squaredSum = this.x * this.x + this.y * this.y + this.z * this.z;
        if ((double)squaredSum < 1.0E-5) {
            return false;
        }
        float f1 = MathUtil.fastInvSqrt(squaredSum);
        this.x *= f1;
        this.y *= f1;
        this.z *= f1;
        return true;
    }

    public void crossProduct(Vec3f vector) {
        float f = this.x;
        float f1 = this.y;
        float f2 = this.z;
        float f3 = vector.x;
        float f4 = vector.y;
        float f5 = vector.z;
        this.x = f1 * f5 - f2 * f4;
        this.y = f2 * f3 - f * f5;
        this.z = f * f4 - f1 * f3;
    }

    public static float getManhattanDistance(DhApiVec3f a, DhApiVec3f b) {
        return Math.abs(a.x - b.x) + Math.abs(a.y - b.y) + Math.abs(a.z - b.z);
    }

    public static double getDistance(DhApiVec3f a, DhApiVec3f b) {
        return Math.sqrt(Math.pow(a.x - b.x, 2.0) + Math.pow(a.y - b.y, 2.0) + Math.pow(a.z - b.z, 2.0));
    }

    public void set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public Vec3f copy() {
        return new Vec3f(this.x, this.y, this.z);
    }
}

