/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.utils;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import dev.isxander.yacl3.debug.DebugProperties;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class GuiUtils {
    public static void drawSpecial(GuiGraphics graphics, Consumer<MultiBufferSource> consumer) {
        MultiBufferSource.BufferSource bufferSource = graphics.m_280091_();
        consumer.accept((MultiBufferSource)bufferSource);
        bufferSource.m_109911_();
    }

    public static void blitGuiTex(GuiGraphics graphics, ResourceLocation texture, int x, int y, float u, float v, int textureWidth, int textureHeight, int width, int height) {
        GuiUtils.blitGuiTex(graphics, texture, x, y, u, v, textureWidth, textureHeight, width, height, false);
    }

    public static void blitGuiTex(GuiGraphics graphics, ResourceLocation texture, int x, int y, float u, float v, int textureWidth, int textureHeight, int width, int height, boolean linearFiltering) {
        GuiUtils.doTextureFiltering();
        graphics.m_280163_(texture, x, y, u, v, textureWidth, textureHeight, width, height);
    }

    public static void blitGuiTexColor(GuiGraphics graphics, ResourceLocation texture, int x, int y, float u, float v, int textureWidth, int textureHeight, int width, int height, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        graphics.m_280246_(r, g, b, a);
        graphics.m_280163_(texture, x, y, u, v, textureWidth, textureHeight, width, height);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static MutableComponent translatableFallback(String key, Component fallback) {
        if (Language.m_128107_().m_6722_(key)) {
            return Component.m_237115_((String)key);
        }
        return fallback.m_6881_();
    }

    public static String shortenString(String string, Font font, int maxWidth, String suffix) {
        if (((String)string).isEmpty()) {
            return string;
        }
        boolean firstIter = true;
        while (font.m_92895_((String)string) > maxWidth) {
            string = ((String)string).substring(0, Math.max(((String)string).length() - 1 - (firstIter ? 1 : suffix.length() + 1), 0)).trim();
            if (((String)(string = (String)string + suffix)).equals(suffix)) break;
            firstIter = false;
        }
        return string;
    }

    public static void setPixelARGB(NativeImage nativeImage, int x, int y, int argb) {
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        int abgr = a << 24 | b << 16 | g << 8 | r;
        nativeImage.m_84988_(x, y, abgr);
    }

    public static void doTextureFiltering() {
        if (DebugProperties.IMAGE_FILTERING) {
            GlStateManager._texParameter((int)3553, (int)10240, (int)9729);
            GlStateManager._texParameter((int)3553, (int)10241, (int)9729);
        }
    }
}

