/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.io.nbt;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.EnumSet;
import journeymap.common.Journeymap;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.storage.ChunkSerializer;
import net.minecraft.world.level.levelgen.Heightmap;
import org.apache.logging.log4j.Logger;

public class CustomChunkReader {
    private static final Logger logger = Journeymap.getLogger();

    public static ProcessedChunk read(ServerLevel level, PoiManager manager, ChunkPos chunkPos, CompoundTag chunkTag) {
        if (ChunkStatus.ChunkType.LEVELCHUNK == ChunkSerializer.m_63485_((CompoundTag)chunkTag)) {
            byte[][][][] lights = new byte[24][16][16][16];
            boolean lightOn = chunkTag.m_128471_("isLightOn");
            ListTag sections = chunkTag.m_128437_("sections", 10);
            int sectionsCount = level.m_151559_();
            LevelChunkSection[] chunkSections = new LevelChunkSection[sectionsCount];
            Registry registry = level.m_9598_().m_175515_(Registries.f_256952_);
            Codec codec = ChunkSerializer.m_188260_((Registry)registry);
            for (int j = 0; j < sections.size(); ++j) {
                CompoundTag section = sections.m_128728_(j);
                byte sectionTopY = section.m_128445_("Y");
                int sectionIndex = level.m_151566_((int)sectionTopY);
                if (sectionIndex >= 0 && sectionIndex < chunkSections.length) {
                    LevelChunkSection chunkSection;
                    PalettedContainer blockStateContainer = section.m_128425_("block_states", 10) ? (PalettedContainer)ChunkSerializer.f_188227_.parse((DynamicOps)NbtOps.f_128958_, (Object)section.m_128469_("block_states")).promotePartial(message -> ChunkSerializer.m_188239_((ChunkPos)chunkPos, (int)sectionTopY, (String)message)).getOrThrow(false, arg_0 -> ((Logger)logger).error(arg_0)) : new PalettedContainer((IdMap)Block.f_49791_, (Object)Blocks.f_50016_.m_49966_(), PalettedContainer.Strategy.f_188137_);
                    Object biomeContainer = section.m_128425_("biomes", 10) ? (PalettedContainerRO)codec.parse((DynamicOps)NbtOps.f_128958_, (Object)section.m_128469_("biomes")).promotePartial(message -> ChunkSerializer.m_188239_((ChunkPos)chunkPos, (int)sectionTopY, (String)message)).getOrThrow(false, arg_0 -> ((Logger)logger).error(arg_0)) : new PalettedContainer(registry.m_206115_(), (Object)registry.m_246971_(Biomes.f_48202_), PalettedContainer.Strategy.f_188138_);
                    chunkSections[sectionIndex] = chunkSection = new LevelChunkSection(blockStateContainer, (PalettedContainerRO)biomeContainer);
                    manager.m_280570_(SectionPos.m_123196_((ChunkPos)chunkPos, (int)sectionTopY), chunkSection);
                }
                if (!lightOn || !section.m_128425_("BlockLight", 7)) continue;
                SectionPos lightPos = SectionPos.m_123196_((ChunkPos)chunkPos, (int)sectionTopY);
                byte[] lightsArray = section.m_128463_("BlockLight");
                for (int z = 0; z <= 15; ++z) {
                    for (int x = 0; x <= 15; ++x) {
                        for (int y = lightPos.m_123234_(); y <= lightPos.m_123247_(); ++y) {
                            if (lightsArray.length != 2048) continue;
                            int localY = SectionPos.m_123207_((int)y);
                            lights[j][x][localY][z] = CustomChunkReader.getSectionLightValue(lightsArray, x, localY, z);
                        }
                    }
                }
            }
            LevelChunk chunkAccess = new LevelChunk((Level)level.m_6018_(), chunkPos, null, null, null, 0L, chunkSections, null, null);
            chunkAccess.m_8094_(lightOn);
            CompoundTag heightmaps = chunkTag.m_128469_("Heightmaps");
            EnumSet<Heightmap.Types> heightmapEnums = EnumSet.noneOf(Heightmap.Types.class);
            for (Heightmap.Types heightmapTypes : chunkAccess.m_6415_().m_62500_()) {
                String key = heightmapTypes.m_64294_();
                if (heightmaps.m_128425_(key, 12)) {
                    chunkAccess.m_6511_(heightmapTypes, heightmaps.m_128467_(key));
                    continue;
                }
                heightmapEnums.add(heightmapTypes);
            }
            Heightmap.m_64256_((ChunkAccess)chunkAccess, heightmapEnums);
            return new ProcessedChunk(chunkAccess, lights);
        }
        return null;
    }

    private static byte getSectionLightValue(byte[] array, int x, int y, int z) {
        try {
            if (array != null) {
                int index = y << 8 | (z << 4) + x;
                int byteIndex = index >> 1;
                int nibbleIndex = index & 1;
                return (byte)(array[byteIndex] >> 4 * nibbleIndex & 0xF);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public record ProcessedChunk(LevelChunk chunk, byte[][][][] light) {
    }
}

