/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.config;

import com.electronwill.nightconfig.core.file.FileWatcher;
import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.core.ModernFixMixinPlugin;
import org.embeddedt.modernfix.util.CommonModUtil;

public class NightConfigFixer {
    public static final LinkedHashSet<Runnable> configsToReload = new LinkedHashSet();
    private static boolean couldShowMessage = true;

    public static void monitorFileWatcher() {
        if (!ModernFixMixinPlugin.instance.isOptionEnabled("bugfix.fix_config_crashes.NightConfigFixerMixin")) {
            return;
        }
        CommonModUtil.runWithoutCrash(() -> {
            FileWatcher watcher = FileWatcher.defaultInstance();
            Field field = FileWatcher.class.getDeclaredField("watchedFiles");
            field.setAccessible(true);
            ConcurrentHashMap theMap = (ConcurrentHashMap)field.get(watcher);
            field.set(watcher, new MonitoringMap(theMap));
            ModernFixMixinPlugin.instance.logger.info("Applied Forge config corruption patch");
        }, "replacing Night Config watchedFiles map");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runReloads() {
        ArrayList<Runnable> runnablesToRun;
        LinkedHashSet<Runnable> linkedHashSet = configsToReload;
        synchronized (linkedHashSet) {
            runnablesToRun = new ArrayList<Runnable>(configsToReload);
            configsToReload.clear();
        }
        for (Runnable r : runnablesToRun) {
            try {
                r.run();
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        ModernFix.LOGGER.info("Processed {} config reloads", (Object)runnablesToRun.size());
        couldShowMessage = true;
    }

    private static void triggerConfigMessage() {
    }

    static class MonitoringMap
    extends ConcurrentHashMap<Path, Object> {
        private static final Class<?> WATCHED_FILE = (Class)LamdbaExceptionUtils.uncheck(() -> Class.forName("com.electronwill.nightconfig.core.file.FileWatcher$WatchedFile"));
        private static final Field CHANGE_HANDLER = ObfuscationReflectionHelper.findField(WATCHED_FILE, (String)"changeHandler");

        public MonitoringMap(ConcurrentHashMap<Path, ?> oldMap) {
            super(oldMap);
        }

        @Override
        public Object computeIfAbsent(Path key, Function<? super Path, ?> mappingFunction) {
            return super.computeIfAbsent(key, (? super K path) -> {
                Object watchedFile = mappingFunction.apply((Path)path);
                try {
                    Runnable changeHandler = (Runnable)CHANGE_HANDLER.get(watchedFile);
                    CHANGE_HANDLER.set(watchedFile, new MonitoringConfigTracker(changeHandler));
                }
                catch (ReflectiveOperationException e) {
                    e.printStackTrace();
                }
                return watchedFile;
            });
        }
    }

    static class MonitoringConfigTracker
    implements Runnable {
        private final Runnable configTracker;

        MonitoringConfigTracker(Runnable r) {
            this.configTracker = r;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LinkedHashSet<Runnable> linkedHashSet = configsToReload;
            synchronized (linkedHashSet) {
                if (FMLLoader.getDist().isClient()) {
                    NightConfigFixer.triggerConfigMessage();
                }
                if (configsToReload.size() == 0) {
                    ModernFixMixinPlugin.instance.logger.info("Please use /{} to reload any changed mod config files", (Object)(FMLLoader.getDist().isDedicatedServer() ? "mfsrc" : "mfrc"));
                }
                configsToReload.add(this.configTracker);
            }
        }
    }
}

